/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem.simulation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.internal.core.elementcontrols.IPJobControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPProcessControl;
import org.eclipse.ptp.rtsystem.IControlSystem;
import org.eclipse.ptp.rtsystem.IRuntimeListener;
import org.eclipse.ptp.rtsystem.JobRunConfiguration;
import org.eclipse.ptp.rtsystem.event.IRuntimeEvent;
import org.eclipse.ptp.rtsystem.simulation.SimJobState;
import org.eclipse.ptp.rtsystem.simulation.SimProcess;

public class SimulationControlSystem
implements IControlSystem {
    protected int numJobs = -1;
    protected List listeners = new ArrayList(2);
    protected Thread runningAppEventsThread = null;
    protected Thread runningAppFinishThread = null;
    protected HashMap processMap;
    protected Vector simJobs = new Vector();

    public boolean isHealthy() {
        return true;
    }

    public void startup() {
        this.processMap = new HashMap();
    }

    public void run(int jobID, JobRunConfiguration jobRunConfig) {
        ++this.numJobs;
        String s = new String("job" + jobID);
        SimJobState ss = new SimJobState();
        ss.jobname = s;
        ss.spawned_first_node = 0;
        ss.spawned_procs_per_node = 0;
        ss.spawned_num_procs = 0;
        ss.machine_name = jobRunConfig.getMachineName();
        ss.spawned_num_procs = jobRunConfig.getNumberOfProcesses();
        ss.spawned_procs_per_node = jobRunConfig.getNumberOfProcessesPerNode();
        ss.spawned_first_node = jobRunConfig.getFirstNodeNumber();
        this.processMap.put(s, new Integer(ss.spawned_num_procs));
        ss.spawned_app_state = "starting";
        ss.spawned_app_exit_code = new String("");
        ss.spawned_app_signal = new String("");
        this.simJobs.addElement(ss);
    }

    public void terminateJob(IPJob jobIn) {
        IPJobControl job = (IPJobControl)jobIn;
        String tname = (String)job.getAttribute("ATTRIB_NAME");
        IPProcess[] ps = job.getProcesses();
        int i = 0;
        while (i < ps.length) {
            ps[i].setTerminated(true);
            if (ps[i] instanceof SimProcess) {
                ((Process)((Object)ps[i])).destroy();
            }
            ++i;
        }
        i = 0;
        while (i < this.simJobs.size()) {
            SimJobState ss = (SimJobState)this.simJobs.elementAt(i);
            if (ss.jobname.equals(tname)) {
                ss.spawned_app_state = "exited-signalled";
                ss.spawned_app_signal = new String("SIGTERM");
                return;
            }
            ++i;
        }
    }

    public String[] getJobs() {
        int i = 0;
        Set set = this.processMap.keySet();
        String[] ne = new String[set.size()];
        for (String key : set) {
            ne[i++] = new String(key);
        }
        return ne;
    }

    private String getProcessNodeName(String procName) {
        String job = procName.substring(0, procName.indexOf("process") - 1);
        int i = 0;
        while (i < this.simJobs.size()) {
            SimJobState ss = (SimJobState)this.simJobs.elementAt(i);
            if (ss.jobname.equals(job)) {
                String s = procName.substring(procName.indexOf("process") + 7, procName.length());
                int procNum = -1;
                try {
                    procNum = new Integer(s);
                }
                catch (NumberFormatException numberFormatException) {}
                if (procNum != -1) {
                    return String.valueOf(ss.machine_name) + "_node" + (ss.spawned_first_node + procNum / ss.spawned_procs_per_node);
                }
            }
            ++i;
        }
        return "";
    }

    private String getProcessStatus(String procName) {
        String job = procName.substring(0, 4);
        int i = 0;
        while (i < this.simJobs.size()) {
            SimJobState ss = (SimJobState)this.simJobs.elementAt(i);
            if (ss.jobname.equals(job)) {
                return ss.spawned_app_state;
            }
            ++i;
        }
        return "-1";
    }

    private String getProcessExitCode(String procName) {
        String job = procName.substring(0, 4);
        int i = 0;
        while (i < this.simJobs.size()) {
            SimJobState ss = (SimJobState)this.simJobs.elementAt(i);
            if (ss.jobname.equals(job)) {
                return ss.spawned_app_exit_code;
            }
            ++i;
        }
        return "-1";
    }

    private String getProcessSignal(String procName) {
        String job = procName.substring(0, 4);
        int i = 0;
        while (i < this.simJobs.size()) {
            SimJobState ss = (SimJobState)this.simJobs.elementAt(i);
            if (ss.jobname.equals(job)) {
                return ss.spawned_app_signal;
            }
            ++i;
        }
        return "-1";
    }

    public String[] getAllProcessesAttributes(IPJob job, String[] attribs) {
        IPProcess[] procs = job.getSortedProcesses();
        String[] allvals = new String[attribs.length * procs.length];
        int i = 0;
        while (i < procs.length) {
            String[] pvals = this.getProcessAttributes(procs[i], attribs);
            int j = 0;
            while (j < pvals.length) {
                allvals[i * pvals.length + j] = new String(pvals[j]);
                ++j;
            }
            ++i;
        }
        return allvals;
    }

    public String[] getProcessAttributes(IPProcess procIn, String[] attribs) {
        IPProcessControl proc = (IPProcessControl)procIn;
        String procName = proc.getElementName();
        String[] retstr = new String[attribs.length];
        int i = 0;
        while (i < attribs.length) {
            String attrib = attribs[i];
            String s = null;
            if (attrib.equals("ATTRIB_PROCESS_PID")) {
                s = "" + (int)(Math.random() * 10000.0) + 1000;
            } else if (attrib.equals("ATTRIB_PROCESS_EXIT_CODE")) {
                s = this.getProcessExitCode(procName);
            } else if (attrib.equals("ATTRIB_PROCESS_SIGNAL")) {
                s = this.getProcessSignal(procName);
            } else if (attrib.equals("ATTRIB_PROCESS_STATUS")) {
                s = this.getProcessStatus(procName);
            } else if (attrib.equals("ATTRIB_PROCESS_NODE_NAME")) {
                s = this.getProcessNodeName(procName);
            }
            retstr[i] = new String(s);
            ++i;
        }
        return retstr;
    }

    public void addRuntimeListener(IRuntimeListener listener) {
        this.listeners.add(listener);
    }

    public void removeRuntimeListener(IRuntimeListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void fireEvent(IRuntimeEvent event) {
        if (this.listeners == null) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((IRuntimeListener)i.next()).performRuntimeEvent(event);
        }
    }

    public void shutdown() {
        this.listeners.clear();
        this.listeners = null;
    }
}

