/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DebugJobStorage {
    private static Map storages = new HashMap();
    private String name;
    private Map jobMap = new HashMap();

    public DebugJobStorage(String name) {
        if (DebugJobStorage.containsKey(name)) {
            this.name = String.valueOf(name) + "1";
            DebugJobStorage.addDebugStorage(this.name, this);
            throw new IllegalArgumentException("Key: " + name + " is already defined.");
        }
        this.name = name;
        DebugJobStorage.addDebugStorage(this.name, this);
    }

    public void closeDebugJobStorage() {
        Iterator i = this.jobMap.values().iterator();
        while (i.hasNext()) {
            ((Storage)i.next()).clean();
        }
        this.jobMap.clear();
        DebugJobStorage.removeDebugStorage(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Storage getJobStorage(String job_id) {
        Map map = this.jobMap;
        synchronized (map) {
            if (!this.jobMap.containsKey(job_id)) {
                this.jobMap.put(job_id, new Storage());
            }
            return (Storage)this.jobMap.get(job_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobStorage(String job_id) {
        Map map = this.jobMap;
        synchronized (map) {
            Storage storage = (Storage)this.jobMap.remove(job_id);
            if (storage != null) {
                storage.clean();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getJobValueIterator() {
        Map map = this.jobMap;
        synchronized (map) {
            ArrayList values = new ArrayList();
            Iterator i = this.jobMap.values().iterator();
            while (i.hasNext()) {
                values.addAll(((Storage)i.next()).getValues());
            }
            return values.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getJobValues() {
        Map map = this.jobMap;
        synchronized (map) {
            ArrayList values = new ArrayList();
            Iterator i = this.jobMap.values().iterator();
            while (i.hasNext()) {
                values.addAll(((Storage)i.next()).getValues());
            }
            return values.toArray(new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getValues(String job_id) {
        Map map = this.jobMap;
        synchronized (map) {
            return this.getJobStorage(job_id).getValues().toArray(new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getValueIterator(String job_id) {
        Map map = this.jobMap;
        synchronized (map) {
            return this.getJobStorage(job_id).getValueIterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(String job_id, String key) {
        Map map = this.jobMap;
        synchronized (map) {
            return this.getJobStorage(job_id).getStore(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(String job_id, String key, Object value) {
        Map map = this.jobMap;
        synchronized (map) {
            this.getJobStorage(job_id).addStore(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeValue(String job_id, String key) {
        Map map = this.jobMap;
        synchronized (map) {
            return this.getJobStorage(job_id).removeStore(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsKey(String name) {
        Map map = storages;
        synchronized (map) {
            return storages.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DebugJobStorage getDebugStorage(String name) {
        Map map = storages;
        synchronized (map) {
            return (DebugJobStorage)storages.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDebugStorage(String name, DebugJobStorage storage) {
        Map map = storages;
        synchronized (map) {
            storages.put(name, storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDebugStorage(String name) {
        Map map = storages;
        synchronized (map) {
            DebugJobStorage storage = (DebugJobStorage)storages.remove(name);
            if (storage != null) {
                storage.closeDebugJobStorage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDebugStorages() {
        Map map = storages;
        synchronized (map) {
            Iterator i = storages.values().iterator();
            while (i.hasNext()) {
                ((DebugJobStorage)i.next()).closeDebugJobStorage();
            }
        }
        storages.clear();
    }

    private class Storage {
        Map aMap = new HashMap();

        private Storage() {
        }

        void clean() {
            this.aMap.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean containsStore(String key) {
            Map map = this.aMap;
            synchronized (map) {
                return this.aMap.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addStore(String key, Object value) {
            Map map = this.aMap;
            synchronized (map) {
                this.aMap.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object removeStore(String key) {
            Map map = this.aMap;
            synchronized (map) {
                return this.aMap.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getStore(String key) {
            Map map = this.aMap;
            synchronized (map) {
                return this.aMap.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Collection getValues() {
            Map map = this.aMap;
            synchronized (map) {
                return this.aMap.values();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Iterator getValueIterator() {
            Map map = this.aMap;
            synchronized (map) {
                return this.aMap.values().iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Iterator getKeyIterator() {
            Map map = this.aMap;
            synchronized (map) {
                return this.aMap.keySet().iterator();
            }
        }
    }
}

