/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PTPPreferenceStore
implements IPreferenceStore {
    private Preferences fPreferences;
    private HashMap fListeners = new HashMap();

    public PTPPreferenceStore(Preferences pref) {
        this.fPreferences = pref;
    }

    public void addPropertyChangeListener(final IPropertyChangeListener listener) {
        Preferences.IPropertyChangeListener l = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                listener.propertyChange(new PropertyChangeEvent((Object)PTPPreferenceStore.this, event.getProperty(), event.getNewValue(), event.getOldValue()));
            }
        };
        this.fListeners.put(listener, l);
    }

    public boolean contains(String name) {
        return this.getPreferences().contains(name);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        Iterator it = this.fListeners.keySet().iterator();
        while (it.hasNext()) {
            ((IPropertyChangeListener)it.next()).propertyChange(new PropertyChangeEvent((Object)this, name, oldValue, newValue));
        }
    }

    public boolean getBoolean(String name) {
        return this.fPreferences.getBoolean(name);
    }

    public boolean getDefaultBoolean(String name) {
        return this.fPreferences.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.fPreferences.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.fPreferences.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.fPreferences.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.fPreferences.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.fPreferences.getDefaultString(name);
    }

    public double getDouble(String name) {
        return this.fPreferences.getDouble(name);
    }

    public float getFloat(String name) {
        return this.fPreferences.getFloat(name);
    }

    public int getInt(String name) {
        return this.fPreferences.getInt(name);
    }

    public long getLong(String name) {
        return this.fPreferences.getLong(name);
    }

    public String getString(String name) {
        return this.fPreferences.getString(name);
    }

    public boolean isDefault(String name) {
        return this.fPreferences.isDefault(name);
    }

    public boolean needsSaving() {
        return this.getPreferences().needsSaving();
    }

    public void putValue(String name, String value) {
        this.getPreferences().setValue(name, value);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove(listener);
    }

    public void setDefault(String name, double value) {
        this.getPreferences().setDefault(name, value);
    }

    public void setDefault(String name, float value) {
        this.getPreferences().setDefault(name, value);
    }

    public void setDefault(String name, int value) {
        this.getPreferences().setDefault(name, value);
    }

    public void setDefault(String name, long value) {
        this.getPreferences().setDefault(name, value);
    }

    public void setDefault(String name, String defaultObject) {
        this.getPreferences().setDefault(name, defaultObject);
    }

    public void setDefault(String name, boolean value) {
        this.getPreferences().setDefault(name, value);
    }

    public void setToDefault(String name) {
        this.getPreferences().setToDefault(name);
    }

    public void setValue(String name, double value) {
        this.getPreferences().setValue(name, value);
    }

    public void setValue(String name, float value) {
        this.getPreferences().setValue(name, value);
    }

    public void setValue(String name, int value) {
        this.getPreferences().setValue(name, value);
    }

    public void setValue(String name, long value) {
        this.getPreferences().setValue(name, value);
    }

    public void setValue(String name, String value) {
        this.getPreferences().setValue(name, value);
    }

    public void setValue(String name, boolean value) {
        this.getPreferences().setValue(name, value);
    }

    protected Preferences getPreferences() {
        return this.fPreferences;
    }
}

