/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIExpression;
import org.eclipse.ptp.debug.core.model.IPType;
import org.eclipse.ptp.debug.core.model.IPValue;
import org.eclipse.ptp.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;
import org.eclipse.ptp.debug.internal.core.model.PExpression;
import org.eclipse.ptp.debug.internal.core.model.PStackFrame;
import org.eclipse.ptp.debug.internal.core.model.PTPMemoryBlockExtension;
import org.eclipse.ptp.debug.internal.core.model.PThread;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PTPMemoryBlockRetrievalExtension
extends PlatformObject
implements IMemoryBlockRetrievalExtension {
    private static final String MEMORY_BLOCK_EXPRESSION_LIST = "memoryBlockExpressionList";
    private static final String MEMORY_BLOCK_EXPRESSION = "expression";
    private static final String ATTR_MEMORY_BLOCK_EXPRESSION_TEXT = "text";
    PDebugTarget fDebugTarget;

    public PTPMemoryBlockRetrievalExtension(PDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
    }

    protected PDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public void initialize() {
        ILaunchConfiguration config = this.getDebugTarget().getLaunch().getLaunchConfiguration();
        try {
            String memento = config.getAttribute("org.eclipse.ptp.launch.MEMORY_BLOCKS", "");
            if (memento != null && memento.trim().length() != 0) {
                this.initializeFromMemento(memento);
            }
        }
        catch (CoreException e) {
            PTPDebugCorePlugin.log(e);
        }
    }

    private void initializeFromMemento(String memento) throws CoreException {
        Element root = DebugPlugin.parseDocument((String)memento);
        if (root.getNodeName().equalsIgnoreCase(MEMORY_BLOCK_EXPRESSION_LIST)) {
            ArrayList<String> expressions = new ArrayList<String>();
            NodeList list = root.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(MEMORY_BLOCK_EXPRESSION)) {
                    String exp = entry.getAttribute(ATTR_MEMORY_BLOCK_EXPRESSION_TEXT);
                    expressions.add(exp);
                }
                ++i;
            }
            this.createMemoryBlocks(expressions.toArray(new String[expressions.size()]));
            return;
        }
        this.abort(InternalDebugCoreMessages.getString("PTPMemoryBlockRetrievalExtension.3"), null);
    }

    private void createMemoryBlocks(String[] expressions) {
        ArrayList<PTPMemoryBlockExtension> list = new ArrayList<PTPMemoryBlockExtension>(expressions.length);
        int i = 0;
        while (i < expressions.length) {
            IAddress address = this.getDebugTarget().getAddressFactory().createAddress(expressions[i]);
            if (address != null) {
                list.add(new PTPMemoryBlockExtension(this.getDebugTarget(), address.toHexAddressString(), address.getValue()));
            }
            ++i;
        }
        DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(list.toArray(new IMemoryBlock[list.size()]));
    }

    public String getMemento() throws CoreException {
        IMemoryBlock[] blocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks((IDebugTarget)this.getDebugTarget());
        Document document = DebugPlugin.newDocument();
        Element element = document.createElement(MEMORY_BLOCK_EXPRESSION_LIST);
        int i = 0;
        while (i < blocks.length) {
            if (blocks[i] instanceof IMemoryBlockExtension) {
                Element child = document.createElement(MEMORY_BLOCK_EXPRESSION);
                try {
                    child.setAttribute(ATTR_MEMORY_BLOCK_EXPRESSION_TEXT, ((IMemoryBlockExtension)blocks[i]).getBigBaseAddress().toString());
                    element.appendChild(child);
                }
                catch (DebugException e) {
                    PTPDebugCorePlugin.log(e.getStatus());
                }
            }
            ++i;
        }
        document.appendChild(element);
        return DebugPlugin.serializeDocument((Document)document);
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(String expression, Object selected) throws DebugException {
        String address = null;
        PExpression exp = null;
        String msg = null;
        try {
            IDebugElement debugElement;
            PStackFrame frame;
            if (selected instanceof IDebugElement && (frame = this.getStackFrame(debugElement = (IDebugElement)selected)) != null) {
                IPCDIExpression cdiExpression = frame.getCDITarget().createExpression(expression);
                exp = new PExpression(frame, cdiExpression, null);
                IValue value = exp.getValue();
                if (value instanceof IPValue) {
                    IPType type = ((IPValue)value).getType();
                    if (type != null && (type.isPointer() || type.isIntegralType())) {
                        address = value.getValueString();
                        exp.dispose();
                        IDebugTarget target = debugElement.getDebugTarget();
                        if (target instanceof PDebugTarget && address != null) {
                            BigInteger a = address.startsWith("0x") ? new BigInteger(address.substring(2), 16) : new BigInteger(address);
                            return new PTPMemoryBlockExtension((PDebugTarget)target, expression, a);
                        }
                    } else {
                        msg = MessageFormat.format(InternalDebugCoreMessages.getString("PTPMemoryBlockRetrievalExtension.1"), expression);
                    }
                } else {
                    msg = MessageFormat.format(InternalDebugCoreMessages.getString("PTPMemoryBlockRetrievalExtension.2"), expression);
                }
            }
        }
        catch (PCDIException e) {
            msg = e.getMessage();
        }
        catch (NumberFormatException numberFormatException) {
            msg = MessageFormat.format(InternalDebugCoreMessages.getString("PTPMemoryBlockRetrievalExtension.0"), expression, address);
        }
        throw new DebugException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 5012, msg, null));
    }

    public boolean supportsStorageRetrieval() {
        return true;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        String expression = Long.toHexString(startAddress);
        BigInteger address = new BigInteger(expression, 16);
        expression = String.valueOf(expression) + "0x";
        return new PTPMemoryBlockExtension(this.getDebugTarget(), expression, address);
    }

    private PStackFrame getStackFrame(IDebugElement selected) throws DebugException {
        IStackFrame frame;
        if (selected instanceof PStackFrame) {
            return (PStackFrame)selected;
        }
        if (selected instanceof PThread && (frame = ((PThread)selected).getTopStackFrame()) instanceof PStackFrame) {
            return (PStackFrame)frame;
        }
        return null;
    }

    public void save() {
        ILaunchConfiguration config = this.getDebugTarget().getLaunch().getLaunchConfiguration();
        try {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.ptp.launch.MEMORY_BLOCKS", this.getMemento());
            wc.doSave();
        }
        catch (CoreException e) {
            PTPDebugCorePlugin.log(e.getStatus());
        }
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, message, e);
        throw new CoreException((IStatus)s);
    }

    public void dispose() {
    }
}

