/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.aif;

import java.math.BigInteger;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.AIFFactory;
import org.eclipse.ptp.debug.core.aif.IAIFType;
import org.eclipse.ptp.debug.core.aif.IAIFTypePointer;
import org.eclipse.ptp.debug.core.aif.IAIFValue;
import org.eclipse.ptp.debug.core.aif.IAIFValueNamed;
import org.eclipse.ptp.debug.core.aif.IAIFValuePointer;
import org.eclipse.ptp.debug.core.aif.IValueParent;
import org.eclipse.ptp.debug.internal.core.aif.ValueDerived;
import org.eclipse.ptp.debug.internal.core.aif.ValueIntegral;

public class AIFValuePointer
extends ValueDerived
implements IAIFValuePointer {
    IAIFValue value;
    IAIFValue addrValue;

    public AIFValuePointer(IValueParent parent, IAIFTypePointer type, AIFFactory.SimpleByteBuffer buffer) {
        super(parent, type);
        this.parse(buffer);
    }

    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        byte marker = buffer.get();
        IAIFTypePointer pType = (IAIFTypePointer)this.type;
        switch (marker) {
            case 0: {
                this.value = AIFFactory.UNKNOWNVALUE;
                break;
            }
            case 1: {
                this.addrValue = AIFFactory.getAIFValue(null, (IAIFType)pType.getAddressType(), buffer);
                this.value = AIFFactory.getAIFValue(this.getParent(), pType.getBaseType(), buffer);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.value = AIFFactory.UNKNOWNVALUE;
            }
        }
        this.size = this.addrValue.sizeof() + this.value.sizeof();
    }

    public int getChildrenNumber() throws AIFException {
        int children = this.value.getChildrenNumber();
        if (children == 0) {
            return 1;
        }
        return children;
    }

    public String getValueString() throws AIFException {
        if (this.result == null) {
            this.result = this.value.getValueString();
        }
        return this.result;
    }

    public BigInteger pointerValue() throws AIFException {
        return ValueIntegral.bigIntegerValue(this.addrValue.getValueString());
    }

    public IAIFValue getValue() {
        if (this.value instanceof IAIFValueNamed) {
            return ((IAIFValueNamed)this.value).getValue();
        }
        return this.value;
    }
}

