/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.aif;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.debug.core.aif.AIFFactory;
import org.eclipse.ptp.debug.core.aif.IAIFType;
import org.eclipse.ptp.debug.core.aif.ITypeAggregate;
import org.eclipse.ptp.debug.internal.core.aif.AIFType;

public abstract class TypeAggregate
extends AIFType
implements ITypeAggregate {
    protected List fields = new ArrayList();
    protected List types = new ArrayList();
    protected String name;
    private int size = 0;

    public TypeAggregate(String format) {
        this.parse(format);
    }

    public String getName() {
        return this.name;
    }

    public String[] getFields() {
        return this.fields.toArray(new String[0]);
    }

    public IAIFType[] getTypes() {
        return this.types.toArray(new IAIFType[0]);
    }

    public String getField(int index) {
        return (String)this.fields.get(index);
    }

    public IAIFType getType(int index) {
        return (IAIFType)this.types.get(index);
    }

    public int getNumberOfChildren() {
        return this.fields.size();
    }

    public int sizeof() {
        return this.size;
    }

    protected void parse(String fmt) {
        fmt = this.parseName(fmt);
        while (fmt.length() > 0) {
            fmt = this.parseField(fmt);
            fmt = this.parseType(fmt);
        }
    }

    protected String parseName(String fmt) {
        int pos = fmt.indexOf("|");
        this.name = fmt.substring(0, pos);
        return fmt.substring(pos + 1);
    }

    protected String parseField(String fmt) {
        int pos = fmt.indexOf("=");
        this.fields.add(fmt.substring(0, pos));
        return fmt.substring(pos + 1);
    }

    protected String parseType(String fmt) {
        int pos = this.getSeperatePosition(fmt);
        if (pos > -1) {
            String tmp_fmt = fmt.substring(0, pos);
            if (tmp_fmt.indexOf(123) > -1) {
                pos = this.getSeperatePosition(fmt, ";;;}");
                if (pos == -1) {
                    pos = this.getSeperatePosition(fmt, "}");
                }
            } else if (tmp_fmt.indexOf(40) > -1) {
                pos = this.getSeperatePosition(fmt, ")");
            }
        }
        if (pos == -1) {
            pos = fmt.length();
        }
        IAIFType aifType = AIFFactory.getAIFType(fmt.substring(0, pos));
        this.size += aifType.sizeof();
        this.types.add(aifType);
        if (pos == fmt.length()) {
            return "";
        }
        return fmt.substring(pos + 1);
    }

    protected int getSeperatePosition(String fmt) {
        return this.getSeperatePosition(fmt, "");
    }

    protected int getSeperatePosition(String fmt, String regex) {
        int regex_len = regex.length();
        int pos = fmt.indexOf(String.valueOf(regex) + ",");
        if (pos == -1 && regex_len > 0) {
            pos = fmt.indexOf(regex);
        }
        if (pos > -1) {
            pos += regex_len;
        }
        return pos;
    }

    public String toString() {
        String content = String.valueOf(this.getName()) + "|";
        int i = 0;
        while (i < this.fields.size()) {
            content = String.valueOf(content) + (String)this.fields.get(i) + "=" + ((IAIFType)this.types.get(i)).toString();
            if (i < this.fields.size() - 1) {
                content = String.valueOf(content) + ",";
            }
            ++i;
        }
        return content;
    }
}

