/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.IStreamsProxy2;
import org.eclipse.ptp.debug.external.core.PInputStreamMonitor;
import org.eclipse.ptp.debug.external.core.POutputStreamMonitor;

public class PStreamsProxy
implements IStreamsProxy,
IStreamsProxy2 {
    private POutputStreamMonitor fOutputMonitor;
    private POutputStreamMonitor fErrorMonitor;
    private PInputStreamMonitor fInputMonitor;
    private boolean fClosed = false;

    public PStreamsProxy(InputStream input, InputStream error, OutputStream output) {
        this.fOutputMonitor = new POutputStreamMonitor(input);
        this.fErrorMonitor = new POutputStreamMonitor(error);
        this.fInputMonitor = new PInputStreamMonitor(output);
        this.fOutputMonitor.startMonitoring();
        this.fErrorMonitor.startMonitoring();
        this.fInputMonitor.startMonitoring();
    }

    public void close() {
        if (!this.fClosed) {
            this.fClosed = true;
            this.fOutputMonitor.close();
            this.fErrorMonitor.close();
            this.fInputMonitor.close();
        }
    }

    public void kill() {
        this.fClosed = true;
        this.fOutputMonitor.kill();
        this.fErrorMonitor.kill();
        this.fInputMonitor.close();
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.fErrorMonitor;
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this.fOutputMonitor;
    }

    public void write(String input) throws IOException {
        if (this.fClosed) {
            throw new IOException();
        }
        this.fInputMonitor.write(input);
    }

    public void closeInputStream() throws IOException {
        if (this.fClosed) {
            throw new IOException();
        }
        this.fInputMonitor.closeInputStream();
    }
}

