/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi;

import java.math.BigInteger;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocator;
import org.eclipse.ptp.debug.external.core.cdi.Location;

public class Locator
extends Location
implements IPCDILocator {
    public Locator(String file, String function, int line, BigInteger address) {
        super(file, function, line, address);
    }

    boolean equalFile(String oFile) {
        return Locator.equalString(oFile, this.getFile());
    }

    boolean equalFunction(String oFunction) {
        return Locator.equalString(oFunction, this.getFunction());
    }

    boolean equalLine(int oLine) {
        return oLine == this.getLineNumber();
    }

    boolean equalAddress(BigInteger oAddress) {
        if (oAddress == null && this.getAddress() == null) {
            return true;
        }
        return oAddress != null && oAddress.equals(this.getAddress());
    }

    public static boolean equalString(String f1, String f2) {
        if (f1 != null && f1.length() > 0 && f2 != null && f2.length() > 0) {
            return f1.equals(f2);
        }
        return !(f1 != null && f1.length() != 0 || f2 != null && f2.length() != 0);
    }

    public boolean equals(IPCDILocator locator) {
        if (locator == this) {
            return true;
        }
        String oFile = locator.getFile();
        String oFunction = locator.getFunction();
        int oLine = locator.getLineNumber();
        BigInteger oAddress = locator.getAddress();
        return this.equalFile(oFile) && this.equalFunction(oFunction) && this.equalLine(oLine) && this.equalAddress(oAddress);
    }
}

