/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIMemoryBlock;
import org.eclipse.ptp.debug.external.core.cdi.Manager;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.event.MemoryChangedEvent;
import org.eclipse.ptp.debug.external.core.cdi.model.DataReadMemoryInfo;
import org.eclipse.ptp.debug.external.core.cdi.model.MemoryBlock;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.commands.DataReadMemoryCommand;

public class MemoryManager
extends Manager {
    IPCDIMemoryBlock[] EMPTY_MEMORY_BLOCKS = new IPCDIMemoryBlock[0];
    Map blockMap = new Hashtable();

    public MemoryManager(Session session) {
        super(session, true);
    }

    public void shutdown() {
        this.blockMap.clear();
    }

    synchronized List getMemoryBlockList(Target target) {
        List blockList = (List)this.blockMap.get(target);
        if (blockList == null) {
            blockList = Collections.synchronizedList(new ArrayList());
            this.blockMap.put(target, blockList);
        }
        return blockList;
    }

    public void update(Target target) {
        List blockList = this.getMemoryBlockList(target);
        MemoryBlock[] blocks = blockList.toArray(new MemoryBlock[blockList.size()]);
        ArrayList eventList = new ArrayList(blocks.length);
        int i = 0;
        while (i < blocks.length) {
            if (!blocks[i].isFrozen()) {
                try {
                    this.update(blocks[i], eventList);
                }
                catch (PCDIException pCDIException) {}
            }
            ++i;
        }
        IPCDIEvent[] events = eventList.toArray(new IPCDIEvent[0]);
        target.getDebugger().fireEvents(events);
    }

    public BigInteger[] update(MemoryBlock block, List aList) throws PCDIException {
        MemoryBlock newBlock = this.cloneBlock(block);
        boolean newAddress = !newBlock.getStartAddress().equals(block.getStartAddress());
        BigInteger[] array = this.compareBlocks(block, newBlock);
        block.setDataReadMemoryInfo(newBlock.getDataReadMemoryInfo());
        Target target = (Target)block.getTarget();
        if (array.length > 0 || newAddress) {
            if (aList != null) {
                aList.add(new MemoryChangedEvent(target.getSession(), target.getTask(), block, array));
            } else {
                target.getDebugger().fireEvent((IPCDIEvent)new MemoryChangedEvent(target.getSession(), target.getTask(), block, array));
            }
        }
        return array;
    }

    BigInteger[] compareBlocks(MemoryBlock oldBlock, MemoryBlock newBlock) throws PCDIException {
        byte[] oldBytes = oldBlock.getBytes();
        byte[] newBytes = newBlock.getBytes();
        ArrayList<BigInteger> aList = new ArrayList<BigInteger>(newBytes.length);
        BigInteger distance = newBlock.getStartAddress().subtract(oldBlock.getStartAddress());
        int diff = distance.intValue();
        if (Math.abs(diff) < newBytes.length) {
            int i = 0;
            while (i < newBytes.length) {
                if (i + diff < oldBytes.length && i + diff >= 0 && oldBytes[i + diff] != newBytes[i]) {
                    aList.add(newBlock.getStartAddress().add(BigInteger.valueOf(i)));
                }
                ++i;
            }
        }
        return aList.toArray(new BigInteger[aList.size()]);
    }

    MemoryBlock cloneBlock(MemoryBlock block) throws PCDIException {
        Target target = (Target)block.getTarget();
        String exp = block.getExpression();
        int wordSize = block.getWordSize();
        boolean little = target.isLittleEndian();
        DataReadMemoryInfo info = this.createDataReadMemoryInfo(target, exp, (int)block.getLength(), wordSize);
        return new MemoryBlock(target, exp, wordSize, little, info);
    }

    DataReadMemoryInfo createDataReadMemoryInfo(Target target, String exp, int units, int wordSize) throws PCDIException {
        DataReadMemoryCommand command = new DataReadMemoryCommand(target.getTask(), 0L, exp, 0, wordSize, 1, units, null);
        target.getDebugger().postCommand((IDebugCommand)command);
        DataReadMemoryInfo info = command.getDataReadMemoryInfo();
        if (info == null) {
            throw new PCDIException("No data memory info found");
        }
        return info;
    }

    public IPCDIMemoryBlock createMemoryBlock(Target target, String address, int units, int wordSize) throws PCDIException {
        boolean little = target.isLittleEndian();
        DataReadMemoryInfo info = this.createDataReadMemoryInfo(target, address, units, wordSize);
        MemoryBlock block = new MemoryBlock(target, address, wordSize, little, info);
        List blockList = this.getMemoryBlockList(target);
        blockList.add(block);
        return block;
    }

    public IPCDIMemoryBlock[] getMemoryBlocks(Target target) throws PCDIException {
        List blockList = this.getMemoryBlockList(target);
        return blockList.toArray(new IPCDIMemoryBlock[blockList.size()]);
    }

    public void removeAllBlocks(Target target) throws PCDIException {
        IPCDIMemoryBlock[] blocks = this.getMemoryBlocks(target);
        this.removeBlocks(target, blocks);
    }

    public void removeBlocks(Target target, IPCDIMemoryBlock[] memoryBlocks) throws PCDIException {
        List blockList = (List)this.blockMap.get(target);
        if (blockList != null) {
            blockList.removeAll((Collection)Arrays.asList(memoryBlocks));
        }
    }
}

