/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.breakpoints;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionLocation;
import org.eclipse.ptp.debug.core.cdi.IPCDIAddressLocation;
import org.eclipse.ptp.debug.core.cdi.IPCDICondition;
import org.eclipse.ptp.debug.core.cdi.IPCDIFunctionLocation;
import org.eclipse.ptp.debug.core.cdi.IPCDILineLocation;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocation;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocator;
import org.eclipse.ptp.debug.external.core.cdi.Locator;
import org.eclipse.ptp.debug.external.core.cdi.breakpoints.Breakpoint;

public abstract class LocationBreakpoint
extends Breakpoint {
    IPCDILocation fLocation;

    public LocationBreakpoint(int kind, IPCDILocation loc, IPCDICondition cond) {
        super(kind, cond);
        this.fLocation = loc;
    }

    public int getLineNumber() {
        if (this.fLocation instanceof IPCDILineLocation) {
            return ((IPCDILineLocation)this.fLocation).getLineNumber();
        }
        return 0;
    }

    public String getFile() {
        if (this.fLocation instanceof IPCDILineLocation) {
            return ((IPCDILineLocation)this.fLocation).getFile();
        }
        if (this.fLocation instanceof ICDIFunctionLocation) {
            return ((IPCDIFunctionLocation)this.fLocation).getFile();
        }
        return null;
    }

    public BigInteger getAddress() {
        if (this.fLocation instanceof IPCDIAddressLocation) {
            return ((IPCDIAddressLocation)this.fLocation).getAddress();
        }
        return null;
    }

    public String getFunction() {
        if (this.fLocation instanceof IPCDIFunctionLocation) {
            return ((IPCDIFunctionLocation)this.fLocation).getFunction();
        }
        return null;
    }

    public IPCDILocator getLocator() {
        return new Locator(this.getFile(), this.getFunction(), this.getLineNumber(), this.getAddress());
    }
}

