/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.model;

import org.eclipse.ptp.debug.core.aif.AIFFactory;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIExpression;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariable;
import org.eclipse.ptp.debug.external.core.cdi.ExpressionManager;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.SourceManager;
import org.eclipse.ptp.debug.external.core.cdi.model.PObject;
import org.eclipse.ptp.debug.external.core.cdi.model.StackFrame;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;

public class Expression
extends PObject
implements IPCDIExpression {
    private static int ID_COUNT = 0;
    private int id;
    String fExpression;

    public Expression(Target target, String ex) {
        super(target);
        this.fExpression = ex;
        this.id = ++ID_COUNT;
    }

    public String getExpressionText() {
        return this.fExpression;
    }

    public boolean equals(IPCDIExpression obj) {
        if (obj instanceof Expression) {
            Expression other = (Expression)obj;
            return other.id == this.id;
        }
        return false;
    }

    public IAIF getAIF(IPCDIStackFrame frame) throws PCDIException {
        IPCDIVariable var = this.getCDIVariable(frame);
        if (var == null) {
            Target target = (Target)this.getTarget();
            Session session = (Session)target.getSession();
            SourceManager sourceMgr = session.getSourceManager();
            return sourceMgr.getAIF(target, this.getExpressionText());
        }
        return AIFFactory.UNKNOWNAIF();
    }

    public IPCDIVariable getCDIVariable(IPCDIStackFrame frame) throws PCDIException {
        Session session = (Session)this.getTarget().getSession();
        ExpressionManager mgr = session.getExpressionManager();
        return mgr.createVariable((StackFrame)frame, this.getExpressionText());
    }

    public void dispose() throws PCDIException {
        Session session = (Session)this.getTarget().getSession();
        ExpressionManager mgr = session.getExpressionManager();
        mgr.destroyExpressions((Target)this.getTarget(), new Expression[]{this});
    }
}

