/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.model;

import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDISignal;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.SignalManager;
import org.eclipse.ptp.debug.external.core.cdi.model.PObject;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;

public class Signal
extends PObject
implements IPCDISignal {
    String name;
    boolean stop;
    boolean print;
    boolean pass;
    String desc;

    public Signal(Target target, IPCDISignal sig) {
        super(target);
        this.setSignal(sig);
    }

    public Signal(Target target, String name, boolean stop, boolean print, boolean pass, String desc) {
        super(target);
        this.name = name;
        this.stop = stop;
        this.print = print;
        this.pass = pass;
        this.desc = desc;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStop() {
        return this.stop;
    }

    public boolean isPass() {
        return this.pass;
    }

    public boolean isPrint() {
        return this.print;
    }

    public void handle(boolean isIgnore, boolean isStop) throws PCDIException {
        SignalManager mgr = ((Session)this.getTarget().getSession()).getSignalManager();
        mgr.handle(this, isIgnore, isStop);
    }

    public void setHandle(boolean isIgnore, boolean isStop) {
        this.pass = !isIgnore;
        this.stop = isStop;
    }

    public boolean isIgnore() {
        return !this.isPass();
    }

    public boolean isStopSet() {
        return this.isStop();
    }

    public void signal() throws PCDIException {
        this.getTarget().resume((IPCDISignal)this);
    }

    public void setSignal(IPCDISignal sig) {
        this.name = sig.getName();
        this.stop = sig.isStop();
        this.print = sig.isPrint();
        this.pass = sig.isPass();
        this.desc = sig.getDescription();
    }

    public String toString() {
        return "Name: " + this.name + ", stop: " + this.stop + ", print: " + this.print + ", pass: " + this.pass + ", desc: " + this.desc;
    }
}

