/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.commands;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.external.core.commands.AbstractDebugCommand;
import org.eclipse.ptp.debug.external.core.proxy.ProxyDebugStackframe;

public class ListStackFramesCommand
extends AbstractDebugCommand {
    int low = 0;
    int high = 0;

    public ListStackFramesCommand(BitList tasks, int low, int high) {
        super(tasks);
        this.low = low;
        this.high = high;
    }

    public ListStackFramesCommand(BitList tasks) {
        super(tasks);
    }

    public void preExecCommand(IAbstractDebugger debugger) throws PCDIException {
        this.checkBeforeExecCommand(debugger);
    }

    public void exec(IAbstractDebugger debugger) throws PCDIException {
        debugger.listStackFrames(this.tasks, this.low, this.high);
    }

    public ProxyDebugStackframe[] getStackFrames() throws PCDIException {
        Object res = this.getResultValue();
        if (res instanceof ProxyDebugStackframe[]) {
            return (ProxyDebugStackframe[])res;
        }
        return new ProxyDebugStackframe[0];
    }

    public String getCommandName() {
        return "List stack frames";
    }
}

