/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.proxy;

import java.io.IOException;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.external.core.proxy.AbstractProxyDebugClient;

public class ProxyDebugClient
extends AbstractProxyDebugClient {
    public static final int STEP_INTO = 0;
    public static final int STEP_OVER = 1;
    public static final int STEP_FINISH = 2;

    public void debugStartSession(String prog, String path, String dir, String[] args) throws IOException {
        this.sendCommand("INI", prog, path, dir, args);
    }

    public void debugSetLineBreakpoint(BitList procs, int bpid, boolean isTemporary, boolean isHardware, String file, int line, String expression, int ignoreCount, int tid) throws IOException {
        String[] args = new String[]{Integer.toString(bpid), Integer.toString(isTemporary ? 1 : 0), Integer.toString(isHardware ? 1 : 0), file, Integer.toString(line), expression, Integer.toString(ignoreCount), Integer.toString(tid)};
        this.sendCommand("SLB", procs, args);
    }

    public void debugSetFuncBreakpoint(BitList procs, int bpid, boolean isTemporary, boolean isHardware, String file, String func, String expression, int ignoreCount, int tid) throws IOException {
        String[] args = new String[]{Integer.toString(bpid), Integer.toString(isTemporary ? 1 : 0), Integer.toString(isHardware ? 1 : 0), file, func, expression, Integer.toString(ignoreCount), Integer.toString(tid)};
        this.sendCommand("SFB", procs, args);
    }

    public void debugSetWatchpoint(BitList procs, int bpid, String expression, boolean isAccess, boolean isRead, String condition, int ignoreCount) throws IOException {
        String[] args = new String[]{Integer.toString(bpid), expression, Integer.toString(isAccess ? 1 : 0), Integer.toString(isRead ? 1 : 0), condition, Integer.toString(ignoreCount)};
        this.sendCommand("SWP", procs, args);
    }

    public void debugDeleteBreakpoint(BitList procs, int bpid) throws IOException {
        this.sendCommand("DBP", procs, Integer.toString(bpid));
    }

    public void debugEnableBreakpoint(BitList procs, int bpid) throws IOException {
        this.sendCommand("EAB", procs, Integer.toString(bpid));
    }

    public void debugDisableBreakpoint(BitList procs, int bpid) throws IOException {
        this.sendCommand("DAB", procs, Integer.toString(bpid));
    }

    public void debugConditionBreakpoint(BitList procs, int bpid, String expr) throws IOException {
        this.sendCommand("CBP", procs, Integer.toString(bpid), expr);
    }

    public void debugBreakpointAfter(BitList procs, int bpid, int icount) throws IOException {
        this.sendCommand("BPA", procs, Integer.toString(bpid), Integer.toString(icount));
    }

    public void debugStackInfoDepth(BitList procs) throws IOException {
        this.sendCommand("SID", procs);
    }

    public void debugGo(BitList procs) throws IOException {
        this.sendCommand("GOP", procs);
    }

    public void debugStep(BitList procs, int count, int type) throws IOException {
        this.sendCommand("STP", procs, Integer.toString(count), Integer.toString(type));
    }

    public void debugTerminate(BitList procs) throws IOException {
        this.sendCommand("TRM", procs);
    }

    public void debugInterrupt(BitList procs) throws IOException {
        this.sendCommand("HLT", procs);
    }

    public void debugListStackframes(BitList procs, int low, int high) throws IOException {
        this.sendCommand("LSF", procs, Integer.toString(low), Integer.toString(high));
    }

    public void debugSetCurrentStackframe(BitList procs, int level) throws IOException {
        this.sendCommand("SCS", procs, Integer.toString(level));
    }

    public void debugEvaluateExpression(BitList procs, String expr) throws IOException {
        this.sendCommand("EEX", procs, expr);
    }

    public void debugGetType(BitList procs, String expr) throws IOException {
        this.sendCommand("TYP", procs, expr);
    }

    public void debugListLocalVariables(BitList procs) throws IOException {
        this.sendCommand("LLV", procs);
    }

    public void debugListArguments(BitList procs, int low, int high) throws IOException {
        this.sendCommand("LAR", procs, Integer.toString(low), Integer.toString(low));
    }

    public void debugListGlobalVariables(BitList procs) throws IOException {
        this.sendCommand("LGV", procs);
    }

    public void debugListInfoThreads(BitList procs) throws IOException {
        this.sendCommand("ITH", procs);
    }

    public void debugSetThreadSelect(BitList procs, int threadNum) throws IOException {
        this.sendCommand("THS", procs, Integer.toString(threadNum));
    }

    public void setDataReadMemoryCommand(BitList procs, long offset, String address, String format, int wordSize, int rows, int cols, Character asChar) throws IOException {
        String[] args = new String[]{Long.toString(offset), address, format, Integer.toString(wordSize), Integer.toString(rows), Integer.toString(cols), asChar == null ? "" : asChar.toString()};
        this.sendCommand("DRM", procs, args);
    }

    public void setDataWriteMemoryCommand(BitList procs, long offset, String address, String format, int wordSize, String value) throws IOException {
        String[] args = new String[]{Long.toString(offset), address, format, Integer.toString(wordSize), value};
        this.sendCommand("DWM", procs, args);
    }

    public void debugListSignals(BitList procs, String name) throws IOException {
        this.sendCommand("LSI", procs, name);
    }

    public void debugSignalInfo(BitList procs, String arg) throws IOException {
        this.sendCommand("SIG", procs, arg);
    }

    public void debugCLIHandle(BitList procs, String arg) throws IOException {
        this.sendCommand("CHL", procs, arg);
    }

    public void debugDataEvaluateExpression(BitList procs, String expr) throws IOException {
        this.sendCommand("DEE", procs, expr);
    }

    public void debugGetPartialAIF(BitList procs, String name, String key, boolean listChildren, boolean express) throws IOException {
        String[] args = new String[]{name, key, Integer.toString(listChildren ? 1 : 0), Integer.toString(express ? 1 : 0)};
        this.sendCommand("GPA", procs, args);
    }

    public void debugVariableDelete(BitList procs, String name) throws IOException {
        this.sendCommand("VDE", procs, name);
    }
}

