/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.internal.ui.PDebugUIUtils;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class PInstructionPointerAnnotation2 {
    private Annotation annotation = null;
    private IAnnotationModel annotationModel = null;
    private BitList tasks = null;
    private Position position = null;
    private IResource file = null;
    private IMarker marker = null;
    private String type = null;

    public PInstructionPointerAnnotation2(IResource file, String type, Position position, IAnnotationModel annotationModel) {
        this.file = file;
        this.type = type;
        this.position = position;
        this.annotationModel = annotationModel;
        this.addAnnotationToModel();
    }

    private IMarker createMarker() {
        if (this.file != null && this.file.exists()) {
            try {
                return this.file.createMarker(this.type);
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public IResource getMakerResource() {
        return this.file;
    }

    public IAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.annotation.setType(type);
    }

    public void removeAnnotation() {
        if (this.isMarkerExists()) {
            try {
                this.marker.delete();
                this.marker = null;
            }
            catch (CoreException coreException) {}
        }
        this.annotation.setText("");
        this.annotation.markDeleted(true);
        this.annotationModel.removeAnnotation(this.annotation);
    }

    private boolean isMarkerExists() {
        return this.marker != null && this.marker.exists();
    }

    public boolean isMarkDeleted() {
        return this.annotation.isMarkedDeleted();
    }

    public void addAnnotationToModel() {
        this.marker = this.createMarker();
        this.annotation = this.isMarkerExists() ? new MarkerAnnotation(this.marker) : new Annotation(this.type, false, "");
        this.annotation.markDeleted(false);
        this.annotationModel.addAnnotation(this.annotation, this.position);
    }

    private void setMessage(String message) {
        if (this.isMarkerExists()) {
            try {
                this.marker.setAttribute("message", (Object)message);
            }
            catch (CoreException coreException) {}
        }
        this.annotation.setText(message);
    }

    public void setMessage(boolean isRegister) {
        int[] tasks = this.getTasks().toArray();
        if (tasks.length == 0) {
            this.removeAnnotation();
            return;
        }
        String msg = "Suspended on " + (isRegister ? "registered" : "unregistered") + " " + (tasks.length == 1 ? "process" : "processes") + ": ";
        msg = String.valueOf(msg) + PDebugUIUtils.arrayToString(tasks);
        this.setMessage(msg);
    }

    public void setTasks(BitList tasks) {
        this.tasks = tasks;
    }

    public BitList getTasks() {
        return this.tasks;
    }

    public void addTasks(BitList aTasks) {
        if (this.tasks == null) {
            this.tasks = aTasks.copy();
        }
        if (this.tasks.size() < aTasks.size()) {
            aTasks.or(this.tasks);
            this.tasks = aTasks.copy();
        } else {
            this.tasks.or(aTasks);
        }
    }

    public void removeTasks(BitList aTasks) {
        this.tasks.andNot(aTasks);
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    public boolean contains(BitList aTasks) {
        return this.tasks.intersects(aTasks);
    }

    public int[] containTasks(BitList aTasks) {
        aTasks.and(this.tasks);
        return aTasks.toArray();
    }
}

