/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui;

import java.io.InputStream;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.DebugJobStorage;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.PCDIDebugModel;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.ProcessInputStream;
import org.eclipse.ptp.debug.core.cdi.IPCDISession;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.model.IPDebugElement;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.internal.ui.PAnnotationManager;
import org.eclipse.ptp.debug.internal.ui.PJobVariableManager;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.model.DebugElement;
import org.eclipse.ptp.ui.OutputConsole;
import org.eclipse.ptp.ui.managers.JobManager;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public class UIDebugManager
extends JobManager
implements IBreakpointListener {
    private DebugJobStorage consoleStorage = new DebugJobStorage("Console");
    private PJobVariableManager jobMgr = new PJobVariableManager();
    private PAnnotationManager annotationMgr = null;
    private PCDIDebugModel debugModel = null;
    private boolean prefAutoUpdateVarOnSuspend = false;
    private boolean prefAutoUpdateVarOnChange = false;
    private boolean prefRegisterProc0 = true;
    private final int STEP_INTO = 1;
    private final int STEP_OVER = 2;
    private final int STEP_RETURN = 3;
    private Preferences.IPropertyChangeListener propertyChangeListener = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            String preferenceType = event.getProperty();
            String value = (String)event.getNewValue();
            if (preferenceType.equals(IPDebugConstants.PREF_PTP_DEBUG_REGISTER_PROC_0)) {
                UIDebugManager.this.prefRegisterProc0 = new Boolean(value);
            } else if (preferenceType.equals(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_SUSPEND)) {
                UIDebugManager.this.prefAutoUpdateVarOnSuspend = new Boolean(value);
            } else if (preferenceType.equals(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_CHANGE)) {
                UIDebugManager.this.prefAutoUpdateVarOnChange = new Boolean(value);
            }
        }
    };

    public boolean isAutoUpdateVarOnSuspend() {
        return this.prefAutoUpdateVarOnSuspend;
    }

    public boolean isAutoUpdateVarOnChange() {
        return this.prefAutoUpdateVarOnChange;
    }

    public boolean isRegProc0() {
        return this.prefRegisterProc0;
    }

    public UIDebugManager() {
        PTPDebugUIPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.propertyChangeListener);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.debugModel = PTPDebugCorePlugin.getDebugModel();
        this.annotationMgr = new PAnnotationManager(this);
        this.settingPreference();
    }

    public PJobVariableManager getJobVariableManager() {
        return this.jobMgr;
    }

    private void settingPreference() {
        IPreferenceStore prefStore = PTPDebugUIPlugin.getDefault().getPreferenceStore();
        this.prefRegisterProc0 = prefStore.getBoolean(IPDebugConstants.PREF_PTP_DEBUG_REGISTER_PROC_0);
        this.prefAutoUpdateVarOnSuspend = prefStore.getBoolean(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_SUSPEND);
        this.prefAutoUpdateVarOnChange = prefStore.getBoolean(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_CHANGE);
    }

    public void shutdown() {
        PTPDebugUIPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.propertyChangeListener);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.annotationMgr.shutdown();
        this.jobMgr.shutdown();
        super.shutdown();
    }

    protected IElement createElement(IElementSet set, String key, String name) {
        return new DebugElement((IElement)set, key, name);
    }

    public String getValueText(int taskID) {
        return this.getJobVariableManager().getResultDisplay(this.getCurrentJobId(), taskID);
    }

    public void defaultRegister(IPCDISession session) {
        IPProcess proc;
        if (this.prefRegisterProc0 && (proc = session.getJob().findProcessByTaskId(0)) != null) {
            this.addConsoleWindow(session.getJob(), proc);
            this.registerProcess(session, session.createBitList(0), true);
        }
    }

    public boolean isDebugMode(String job_id) {
        if (this.isNoJob(job_id)) {
            return false;
        }
        return this.isDebugMode(this.findJobById(job_id));
    }

    public boolean isDebugMode(IPJob job) {
        if (job == null) {
            return false;
        }
        return job.isDebug();
    }

    public boolean isRunning(IPJob job) {
        return job != null && !job.isAllStop();
    }

    public boolean isRunning(String job_id) {
        if (this.isNoJob(job_id)) {
            return false;
        }
        return this.isRunning(this.findJobById(job_id));
    }

    public void fireJobChangedEvent(int type, String cur_jid, String pre_jid) {
        this.updateBreakpointMarker("Root");
        try {
            this.removeAllRegisterElements(pre_jid);
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
        super.fireJobChangedEvent(type, cur_jid, pre_jid);
    }

    public IPCDISession getDebugSession(String job_id) {
        if (this.isNoJob(job_id)) {
            return null;
        }
        return this.debugModel.getPCDISession(job_id);
    }

    public IPCDISession getDebugSession(IPJob job) {
        if (job == null) {
            return null;
        }
        return this.debugModel.getPCDISession(job.getIDString());
    }

    public int convertToInt(String id) {
        return Integer.parseInt(id);
    }

    private void addConsoleWindow(IPJob job, IPProcess proc) {
        if (this.consoleStorage.getValue(job.getIDString(), proc.getIDString()) == null) {
            OutputConsole outputConsole = new OutputConsole(proc.getElementName(), (InputStream)new ProcessInputStream(proc));
            this.consoleStorage.addValue(job.getIDString(), proc.getIDString(), (Object)outputConsole);
        }
    }

    private void removeConsoleWindow(IPJob job, IPProcess proc) {
        OutputConsole outputConsole = (OutputConsole)this.consoleStorage.removeValue(job.getIDString(), proc.getIDString());
        if (outputConsole != null) {
            outputConsole.kill();
        }
    }

    private void removeConsoleWindows(IPJob job) {
        Iterator i = this.consoleStorage.getValueIterator(job.getIDString());
        while (i.hasNext()) {
            OutputConsole outputConsole = (OutputConsole)i.next();
            if (outputConsole == null) continue;
            outputConsole.kill();
        }
        this.consoleStorage.removeJobStorage(job.getIDString());
    }

    public void registerProcess(IPCDISession session, BitList tasks, boolean isChanged) {
        if (!tasks.isEmpty()) {
            session.registerTargets(tasks, isChanged);
        }
    }

    public void unregisterProcess(IPCDISession session, BitList tasks, boolean isChanged) {
        if (!tasks.isEmpty()) {
            session.unregisterTargets(tasks, isChanged);
        }
    }

    public void unregisterElements(final IElement[] elements) throws CoreException {
        WorkbenchJob uiJob = new WorkbenchJob("Unregistering elements..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IPJob job = UIDebugManager.this.getCurrentJob();
                if (job == null) {
                    return new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No job found", null);
                }
                IPCDISession session = UIDebugManager.this.getDebugSession(job);
                if (session == null) {
                    return Status.CANCEL_STATUS;
                }
                BitList tasks = session.createEmptyBitList();
                int i = 0;
                while (i < elements.length) {
                    IPProcess proc;
                    if (elements[i].isRegistered() && (proc = UIDebugManager.this.findProcess(job, elements[i].getIDNum())) != null) {
                        UIDebugManager.this.removeConsoleWindow(job, proc);
                        tasks.set(elements[i].getIDNum());
                    }
                    ++i;
                }
                UIDebugManager.this.unregisterProcess(session, tasks, true);
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(false);
        uiJob.setPriority(10);
        uiJob.schedule();
    }

    public void registerElements(final IElement[] elements) throws CoreException {
        WorkbenchJob uiJob = new WorkbenchJob("registering elements..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IPJob job = UIDebugManager.this.getCurrentJob();
                if (job == null) {
                    return new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No job found", null);
                }
                IPCDISession session = UIDebugManager.this.getDebugSession(job);
                if (session == null) {
                    return Status.CANCEL_STATUS;
                }
                BitList tasks = session.createEmptyBitList();
                int i = 0;
                while (i < elements.length) {
                    IPProcess proc;
                    if (!elements[i].isRegistered() && (proc = UIDebugManager.this.findProcess(job, elements[i].getIDNum())) != null && !proc.isAllStop()) {
                        UIDebugManager.this.addConsoleWindow(job, proc);
                        tasks.set(elements[i].getIDNum());
                    }
                    ++i;
                }
                UIDebugManager.this.registerProcess(session, tasks, true);
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(false);
        uiJob.setPriority(10);
        uiJob.schedule();
    }

    public void breakpointAdded(final IBreakpoint breakpoint) {
        if (PTPDebugUIPlugin.isPTPDebugPerspective() && breakpoint instanceof ICLineBreakpoint) {
            WorkbenchJob uiJob = new WorkbenchJob("Removing CLine breakpoint..."){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, true);
                    }
                    catch (CoreException e) {
                        PTPDebugUIPlugin.log(e.getStatus());
                    }
                    return Status.OK_STATUS;
                }
            };
            uiJob.setSystem(true);
            uiJob.setPriority(50);
            uiJob.schedule();
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void updateBreakpointMarker(final String cur_sid) {
        WorkbenchJob uiJob = new WorkbenchJob("Updating breakpoint marker..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    UIDebugManager.this.debugModel.updatePBreakpoints(cur_sid, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.setPriority(10);
        uiJob.schedule();
    }

    public synchronized void removeAllRegisterElements(final String job_id) throws CoreException {
        final IElementHandler elementHandler = this.getElementHandler(job_id);
        if (elementHandler == null) {
            return;
        }
        WorkbenchJob uiJob = new WorkbenchJob("Removing registered processes"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IPJob job = UIDebugManager.this.findJobById(job_id);
                if (job == null) {
                    return Status.CANCEL_STATUS;
                }
                IPCDISession session = UIDebugManager.this.getDebugSession(job);
                if (session == null) {
                    return Status.CANCEL_STATUS;
                }
                BitList tasks = session.createEmptyBitList();
                IElement[] registerElements = elementHandler.getRegisteredElements();
                monitor.beginTask("Removing registering processes....", registerElements.length);
                int i = 0;
                while (i < registerElements.length) {
                    IPProcess proc = UIDebugManager.this.findProcess(job, registerElements[i].getIDNum());
                    if (proc != null) {
                        UIDebugManager.this.removeConsoleWindow(job, proc);
                        tasks.set(registerElements[i].getIDNum());
                    }
                    monitor.worked(1);
                    ++i;
                }
                UIDebugManager.this.unregisterProcess(session, tasks, false);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        uiJob.setPriority(10);
        PlatformUI.getWorkbench().getProgressService().showInDialog(PTPDebugUIPlugin.getActiveWorkbenchShell(), (Job)uiJob);
        uiJob.schedule();
    }

    public void updateRegisterUnRegisterElements(final IElementSet curSet, final IElementSet preSet, final String job_id) {
        WorkbenchJob uiJob = new WorkbenchJob("Updating registered/unregistered processes"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IElementHandler elementHandler = UIDebugManager.this.getElementHandler(job_id);
                if (elementHandler == null) {
                    return Status.CANCEL_STATUS;
                }
                IPJob job = UIDebugManager.this.findJobById(job_id);
                if (job == null) {
                    return Status.CANCEL_STATUS;
                }
                IPCDISession session = UIDebugManager.this.getDebugSession(job);
                if (session == null) {
                    return Status.CANCEL_STATUS;
                }
                BitList regTasks = session.createEmptyBitList();
                BitList unregTasks = session.createEmptyBitList();
                IElement[] registerElements = elementHandler.getRegisteredElements();
                monitor.beginTask("Registering process....", registerElements.length);
                int i = 0;
                while (i < registerElements.length) {
                    IPProcess proc;
                    if (curSet.contains(registerElements[i].getID())) {
                        if ((curSet.isRootSet() || preSet != null && !curSet.equals(preSet) && !preSet.contains(registerElements[i].getID())) && (proc = UIDebugManager.this.findProcess(job, registerElements[i].getIDNum())) != null) {
                            UIDebugManager.this.addConsoleWindow(job, proc);
                            regTasks.set(registerElements[i].getIDNum());
                        }
                    } else {
                        proc = UIDebugManager.this.findProcess(job, registerElements[i].getIDNum());
                        if (proc != null) {
                            UIDebugManager.this.removeConsoleWindow(job, proc);
                            unregTasks.set(registerElements[i].getIDNum());
                        }
                    }
                    monitor.worked(1);
                    ++i;
                }
                UIDebugManager.this.registerProcess(session, regTasks, false);
                UIDebugManager.this.unregisterProcess(session, unregTasks, false);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        uiJob.setPriority(10);
        PlatformUI.getWorkbench().getProgressService().showInDialog(PTPDebugUIPlugin.getActiveWorkbenchShell(), (Job)uiJob);
        uiJob.schedule();
    }

    public synchronized void fireSetEvent(int eventType, IElement[] elements, IElementSet cur_set, IElementSet pre_set) {
        switch (eventType) {
            case 0: {
                BitList created_tasks = new BitList(cur_set.getElementHandler().getSetRoot().size());
                int i = 0;
                while (i < elements.length) {
                    created_tasks.set(this.convertToInt(elements[i].getID()));
                    ++i;
                }
                this.debugModel.createSet(this.getCurrentJobId(), cur_set.getID(), created_tasks);
                break;
            }
            case 1: {
                this.debugModel.deletePBreakpoint(this.getCurrentJobId(), cur_set.getID());
                this.debugModel.deleteSet(this.getCurrentJobId(), cur_set.getID());
                String cur_job_id = this.getCurrentJobId();
                if (cur_job_id == null || cur_job_id.length() <= 0) break;
                this.getJobVariableManager().deleteSet(cur_job_id, cur_set.getID());
                break;
            }
            case 2: {
                if (cur_set == null) break;
                this.annotationMgr.updateAnnotation(cur_set, pre_set);
                this.updateBreakpointMarker(cur_set.getID());
                this.updateRegisterUnRegisterElements(cur_set, pre_set, this.getCurrentJobId());
                this.updateVariableValueOnChange();
                break;
            }
            case 3: {
                BitList added_tasks = new BitList(cur_set.getElementHandler().getSetRoot().size());
                int i = 0;
                while (i < elements.length) {
                    added_tasks.set(this.convertToInt(elements[i].getID()));
                    ++i;
                }
                this.debugModel.addTasks(this.getCurrentJobId(), cur_set.getID(), added_tasks);
                break;
            }
            case 4: {
                BitList removed_tasks = new BitList(cur_set.getElementHandler().getSetRoot().size());
                int i = 0;
                while (i < elements.length) {
                    removed_tasks.set(this.convertToInt(elements[i].getID()));
                    ++i;
                }
                this.debugModel.removeTasks(this.getCurrentJobId(), cur_set.getID(), removed_tasks);
            }
        }
        super.fireSetEvent(eventType, elements, cur_set, pre_set);
    }

    public BitList getTasks(String job_id, String set_id) throws CoreException {
        return this.debugModel.getTasks(job_id, set_id);
    }

    public void resume() throws CoreException {
        this.resume(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void resume(String job_id, String set_id) throws CoreException {
        IPCDISession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No session found", null));
        }
        try {
            session.resume(this.getTasks(job_id, set_id));
        }
        catch (PCDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void suspend() throws CoreException {
        this.suspend(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void suspend(String job_id, String set_id) throws CoreException {
        IPCDISession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No session found", null));
        }
        try {
            session.suspend(this.getTasks(job_id, set_id));
        }
        catch (PCDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void terminate() throws CoreException {
        this.terminate(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void terminate(String job_id, String set_id) throws CoreException {
        IPJob job = this.findJobById(job_id);
        if (this.isDebugMode(job)) {
            IPCDISession session = this.getDebugSession(job);
            if (session == null) {
                throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No session found", null));
            }
            try {
                session.stop(this.getTasks(job_id, set_id));
            }
            catch (PCDIException e) {
                throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
            }
        } else {
            super.terminateAll(job_id);
        }
    }

    public void stepInto() throws CoreException {
        this.stepInto(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void stepInto(String job_id, String set_id) throws CoreException {
        IPCDISession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No session found", null));
        }
        try {
            BitList tasks = this.getTasks(job_id, set_id);
            this.filterRunningTasks(tasks, 1);
            session.steppingInto(tasks);
        }
        catch (PCDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void stepOver() throws CoreException {
        this.stepOver(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void stepOver(String job_id, String set_id) throws CoreException {
        IPCDISession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No session found", null));
        }
        try {
            BitList tasks = this.getTasks(job_id, set_id);
            this.filterRunningTasks(tasks, 2);
            session.steppingOver(tasks);
        }
        catch (PCDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void stepReturn() throws CoreException {
        this.stepReturn(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void stepReturn(String job_id, String set_id) throws CoreException {
        IPCDISession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No session found", null));
        }
        try {
            session.steppingReturn(this.getTasks(job_id, set_id));
        }
        catch (PCDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void removeJob(IPJob job) {
        if (job.isDebug()) {
            this.debugModel.deletePBreakpoint(job.getIDString());
            this.debugModel.deleteJob(job);
            this.debugModel.shutdownSession(job);
            this.annotationMgr.removeAnnotationGroup(job.getIDString());
            this.removeConsoleWindows(job);
        }
        super.removeJob(job);
    }

    public void updateVariableValueOnSuspend() {
        this.updateVariableValue(this.isAutoUpdateVarOnSuspend());
    }

    public void updateVariableValueOnChange() {
        this.updateVariableValue(this.isAutoUpdateVarOnChange());
    }

    public void updateVariableValue(boolean force) {
        this.cleanVariableValue();
        if (force) {
            this.updateVariableValue();
        }
    }

    public void updateVariableValue() {
        this.updateVariableValue(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void updateVariableValue(final String jid, final String sid) {
        if (jid != null) {
            Job uiJob = new Job("Updating variables..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        UIDebugManager.this.getJobVariableManager().updateJobVariableValues(jid, sid, monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            uiJob.setPriority(10);
            PlatformUI.getWorkbench().getProgressService().showInDialog(PTPDebugUIPlugin.getActiveWorkbenchShell(), uiJob);
            uiJob.schedule();
        }
    }

    public void cleanVariableValue() {
        this.getJobVariableManager().cleanupJobVariableValues();
    }

    public Object getDebugObject(IPJob job, int task_id) {
        IPDebugTarget debugTarget;
        IPCDISession session = this.getDebugSession(job);
        if (session != null && (debugTarget = session.getLaunch().getDebugTarget(task_id)) != null) {
            try {
                IThread[] threads = debugTarget.getThreads();
                int i = 0;
                while (i < threads.length) {
                    IStackFrame frame = threads[i].getTopStackFrame();
                    if (frame != null) {
                        return frame;
                    }
                    ++i;
                }
                if (threads.length > 0) {
                    return threads[0];
                }
            }
            catch (DebugException debugException) {
                return debugTarget;
            }
            return debugTarget;
        }
        return null;
    }

    public int getSelectedRegisteredTasks(Object obj) {
        IDebugTarget target = null;
        if (obj instanceof IStackFrame) {
            target = ((IStackFrame)obj).getDebugTarget();
        } else if (obj instanceof IThread) {
            target = ((IThread)obj).getDebugTarget();
        } else if (obj instanceof IDebugTarget) {
            target = (IDebugTarget)obj;
        }
        if (target instanceof IPDebugTarget) {
            return ((IPDebugTarget)target).getTargetID();
        }
        return -1;
    }

    public void filterRunningTasks(BitList tasks, int step) {
        int taskID;
        Object obj;
        ISelection selection;
        Viewer viewer = null;
        IViewPart part = PTPDebugUIPlugin.getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.debug.ui.DebugView");
        if (part != null && part instanceof AbstractDebugView) {
            viewer = ((AbstractDebugView)part).getViewer();
        }
        if (viewer != null && !(selection = viewer.getSelection()).isEmpty() && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IStep && obj instanceof IPDebugElement && tasks.get(taskID = ((IPDebugTarget)((IPDebugElement)obj).getDebugTarget()).getTargetID())) {
            switch (step) {
                case 1: {
                    if (((IStep)obj).canStepInto()) break;
                    tasks.clear(taskID);
                    break;
                }
                case 2: {
                    if (((IStep)obj).canStepOver()) break;
                    tasks.clear(taskID);
                    break;
                }
                case 3: {
                    if (((IStep)obj).canStepReturn()) break;
                    tasks.clear(taskID);
                }
            }
        }
    }
}

