/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.ui.IPTPDebugUIConstants;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.views.ParallelDebugView;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class GotoSet
implements IViewActionDelegate {
    private IStructuredSelection selection = null;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        IViewPart view;
        IPBreakpoint breakpoint = this.getPBreakpoint();
        if (breakpoint != null && (view = PTPDebugUIPlugin.getActiveWorkbenchWindow().getActivePage().findView(IPTPDebugUIConstants.ID_VIEW_PARALLELDEBUG)) instanceof ParallelDebugView) {
            ParallelDebugView pview = (ParallelDebugView)view;
            try {
                String jid = breakpoint.getJobId();
                if (jid.equals("Global")) {
                    jid = "";
                }
                pview.changeJob(jid);
                IElementHandler elementHandler = pview.getCurrentElementHandler();
                if (elementHandler != null) {
                    pview.selectSet(elementHandler.getSet(breakpoint.getSetId()));
                }
                pview.refresh(false);
            }
            catch (CoreException e) {
                PTPDebugUIPlugin.log(e);
            }
        }
    }

    private IPBreakpoint getPBreakpoint() {
        if (this.selection.isEmpty()) {
            return null;
        }
        Object obj = this.selection.getFirstElement();
        if (obj instanceof IPBreakpoint) {
            return (IPBreakpoint)obj;
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            action.setEnabled(this.selection.size() == 1 && this.getPBreakpoint() != null);
        }
    }
}

