/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.actions;

import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.internal.ui.actions.ViewFilterAction;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class ShowFullPathsAction
extends ViewFilterAction {
    protected String getPreferenceKey() {
        return IPDebugConstants.PREF_SHOW_FULL_PATHS;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return true;
    }

    public void run(IAction action) {
        IDebugModelPresentation pres;
        final StructuredViewer viewer = this.getStructuredViewer();
        IDebugView view = (IDebugView)this.getView().getAdapter(IDebugView.class);
        if (view != null && (pres = view.getPresentation(PTPDebugUIPlugin.getUniqueIdentifier())) != null) {
            pres.setAttribute("DISPLAY_FULL_PATHS", (Object)(this.getValue() ? Boolean.TRUE : Boolean.FALSE));
            BusyIndicator.showWhile((Display)viewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    viewer.refresh();
                    IPreferenceStore store = ShowFullPathsAction.this.getPreferenceStore();
                    String key = String.valueOf(ShowFullPathsAction.this.getView().getSite().getId()) + "." + ShowFullPathsAction.this.getPreferenceKey();
                    store.setValue(key, ShowFullPathsAction.this.getValue());
                    PTPDebugUIPlugin.getDefault().savePluginPreferences();
                }
            });
        }
    }
}

