/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views.variable;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ptp.debug.internal.ui.PJobVariableManager;

public class PVariableViewerSorter
extends ViewerSorter {
    private boolean[] sortOrder = new boolean[4];
    private int column = 0;

    public void setColumn(int column) {
        this.column = column;
        this.sortOrder[column] = !this.sortOrder[column];
    }

    public int getColumn() {
        return this.column;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (!(e1 instanceof PJobVariableManager.JobVariable)) {
            return super.compare(viewer, e1, e2);
        }
        boolean isAccending = this.sortOrder[this.column];
        switch (this.column) {
            case 0: {
                if (isAccending) {
                    return ((PJobVariableManager.JobVariable)e1).isEnable() ? 1 : -1;
                }
                return ((PJobVariableManager.JobVariable)e2).isEnable() ? 1 : -1;
            }
        }
        if (viewer instanceof StructuredViewer) {
            ITableLabelProvider lprov = (ITableLabelProvider)((StructuredViewer)viewer).getLabelProvider();
            String name1 = lprov.getColumnText(e1, this.column);
            String name2 = lprov.getColumnText(e2, this.column);
            if (isAccending) {
                return name1.compareTo(name2);
            }
            return name2.compareTo(name1);
        }
        return 0;
    }
}

