/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.dictionary;

import java.util.Hashtable;
import java.util.LinkedList;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.ptp.pldt.openmp.analysis.dictionary.Symbol;

public class Dictionary {
    protected Hashtable textToSymbols_ = new Hashtable();
    protected Hashtable functionToSymbols_ = new Hashtable();
    protected Hashtable stringScopeKeyToSymbol_ = new Hashtable();
    protected IASTTranslationUnit ast_ = null;

    public Dictionary(IASTTranslationUnit ast) {
        this.ast_ = ast;
        this.functionToSymbols_.put(this.ast_, new LinkedList());
    }

    public void insert(IASTSimpleDeclaration decl) {
        IASTDeclarator[] decls = decl.getDeclarators();
        int i = 0;
        while (i < decls.length) {
            this.insert(decls[i], (IASTDeclaration)decl);
            ++i;
        }
    }

    public void insert(IASTDeclarator declarator, IASTDeclaration decl) {
        Symbol symbol = new Symbol(declarator, decl);
        this.insertMember(symbol);
    }

    public void insert(IASTDeclarator declarator, IASTParameterDeclaration decl) {
        Symbol symbol = new Symbol(declarator, decl);
        this.insertMember(symbol);
    }

    protected void insertMember(Symbol symbol) {
        LinkedList<Symbol> ll;
        IASTNode node = symbol.getDefiningFunction();
        try {
            StringScopeKey sskey = new StringScopeKey(symbol.getName());
            this.stringScopeKeyToSymbol_.put(sskey, symbol);
        }
        catch (DOMException e) {
            System.out.println("Dictionary.insert exception " + (Object)((Object)e));
        }
        if (node == null) {
            node = this.ast_;
        }
        if ((ll = (LinkedList<Symbol>)this.functionToSymbols_.get(node)) == null) {
            ll = new LinkedList<Symbol>();
            this.functionToSymbols_.put(node, ll);
        }
        ll.add(symbol);
        String strname = symbol.getName().toString();
        LinkedList<Symbol> nl = (LinkedList<Symbol>)this.textToSymbols_.get(strname);
        if (nl == null) {
            nl = new LinkedList<Symbol>();
            this.textToSymbols_.put(strname, nl);
        }
        nl.add(symbol);
    }

    public Symbol[] getSymbolsFor(String text) {
        LinkedList ll = (LinkedList)this.textToSymbols_.get(text);
        if (ll == null) {
            return new Symbol[0];
        }
        Symbol[] ans = new Symbol[ll.size()];
        int i = 0;
        while (i < ll.size()) {
            ans[i] = (Symbol)ll.get(i);
            ++i;
        }
        return ans;
    }

    public Symbol[] getSymbolsFor(IASTFunctionDefinition fctnDef) {
        LinkedList ll = (LinkedList)this.functionToSymbols_.get(fctnDef);
        if (ll == null) {
            return new Symbol[0];
        }
        Symbol[] ans = new Symbol[ll.size()];
        int i = 0;
        while (i < ll.size()) {
            ans[i] = (Symbol)ll.get(i);
            ++i;
        }
        return ans;
    }

    public Symbol[] getSymbolsFor() {
        LinkedList ll = (LinkedList)this.functionToSymbols_.get(this.ast_);
        if (ll == null) {
            return new Symbol[0];
        }
        Symbol[] ans = new Symbol[ll.size()];
        int i = 0;
        while (i < ll.size()) {
            ans[i] = (Symbol)ll.get(i);
            ++i;
        }
        return ans;
    }

    public Symbol find(IASTName name) throws DOMException {
        StringScopeKey key = new StringScopeKey(name);
        return (Symbol)this.stringScopeKeyToSymbol_.get(key);
    }

    protected static class StringScopeKey {
        public String stringKey_ = "";
        public IScope scopeKey_ = null;

        public StringScopeKey(String stringKey, IScope scopeKey) {
            this.stringKey_ = stringKey;
            this.scopeKey_ = scopeKey;
        }

        public StringScopeKey(IASTName nameNode) throws DOMException {
            this.stringKey_ = nameNode.toString();
            this.scopeKey_ = nameNode.getBinding().getScope();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof StringScopeKey)) {
                return false;
            }
            StringScopeKey thatStringScopeKey = (StringScopeKey)that;
            return thatStringScopeKey.stringKey_.equals(this.stringKey_) && thatStringScopeKey.scopeKey_ == this.scopeKey_;
        }

        public int hashCode() {
            return this.stringKey_.hashCode();
        }
    }
}

