/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.simulation.ui.preferences;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ptp.simulation.ui.preferences.SimulationProjectCreation;
import org.eclipse.ptp.ui.PTPUIPlugin;

public class ManagedCProjectCreation
extends SimulationProjectCreation {
    public ManagedCProjectCreation(String projectName, String fileName) {
        super(projectName, fileName);
    }

    public String getFileExtension() {
        return ".c";
    }

    protected String getTemplateFile() {
        return "ctemplate.txt";
    }

    protected String getEditorID() {
        return "org.eclipse.cdt.ui.editor.CEditor";
    }

    private String getProjectID() {
        return ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID;
    }

    private void addNature(IProject newProject, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 2);
        monitor.subTask("Adding nature...");
        ManagedCProjectNature.addManagedNature((IProject)newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.subTask("Adding nature...");
        ManagedCProjectNature.addManagedBuilder((IProject)newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
    }

    private IProjectType getDefaultProjectType() {
        IProjectType[] types = ManagedBuildManager.getDefinedProjectTypes();
        String os = Platform.getOS();
        String arch = Platform.getOSArch();
        int index = 0;
        while (index < types.length) {
            IProjectType type = types[index];
            if (!type.isAbstract() && !type.isTestProjectType() && type.isSupported()) {
                IConfiguration[] configs = type.getConfigurations();
                int j = 0;
                while (j < configs.length) {
                    List<String> archList;
                    IToolChain tc = configs[j].getToolChain();
                    List<String> osList = Arrays.asList(tc.getOSList());
                    if ((osList.contains("all") || osList.contains(os)) && ((archList = Arrays.asList(tc.getArchList())).contains("all") || archList.contains(arch))) {
                        return type;
                    }
                    ++j;
                }
            }
            ++index;
        }
        return null;
    }

    private IConfiguration[] getDefaultConfigurations(IProjectType type) {
        if (type != null) {
            return type.getConfigurations();
        }
        return new IConfiguration[0];
    }

    protected void createProject(IProjectDescription description, IProject newProject, IProgressMonitor monitor) throws CoreException {
        IStatus initResult;
        CCorePlugin.getDefault().createCProject(description, newProject, monitor, this.getProjectID());
        this.addNature(newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        IManagedProject newManagedProject = null;
        ManagedBuildInfo info = null;
        try {
            info = ManagedBuildManager.createBuildInfo((IResource)newProject);
            IProjectType parent = this.getDefaultProjectType();
            newManagedProject = ManagedBuildManager.createManagedProject((IResource)newProject, (IProjectType)parent);
            if (newManagedProject != null) {
                IConfiguration[] selectedConfigs = this.getDefaultConfigurations(parent);
                int i = 0;
                while (i < selectedConfigs.length) {
                    IConfiguration config = selectedConfigs[i];
                    int id = ManagedBuildManager.getRandomNumber();
                    IConfiguration newConfig = newManagedProject.createConfiguration(config, String.valueOf(config.getId()) + "." + id);
                    newConfig.setArtifactName(newManagedProject.getDefaultArtifactName());
                    ++i;
                }
                IConfiguration defaultCfg = null;
                IConfiguration[] newConfigs = newManagedProject.getConfigurations();
                int i2 = 0;
                while (i2 < newConfigs.length) {
                    if (newConfigs[i2].isSupported()) {
                        defaultCfg = newConfigs[i2];
                        break;
                    }
                    ++i2;
                }
                if (defaultCfg == null && newConfigs.length > 0) {
                    defaultCfg = newConfigs[0];
                }
                if (defaultCfg != null) {
                    ManagedBuildManager.setDefaultConfiguration((IProject)newProject, defaultCfg);
                    ManagedBuildManager.setSelectedConfiguration((IProject)newProject, (IConfiguration)defaultCfg);
                }
                ManagedBuildManager.setNewProjectVersion((IProject)newProject);
                ICDescriptor desc = null;
                try {
                    desc = CCorePlugin.getDefault().getCProjectDescription(newProject, true);
                    desc.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
                }
                catch (CoreException e) {
                    PTPUIPlugin.log((Throwable)e);
                }
            }
        }
        catch (BuildException e) {
            PTPUIPlugin.log((Throwable)e);
        }
        if (newProject != null) {
            this.setIndexer(newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        monitor.subTask("Saving project...");
        if (info != null) {
            info.setValid(true);
            ManagedBuildManager.saveBuildInfo((IProject)newProject, (boolean)false);
        }
        if ((initResult = ManagedBuildManager.initBuildInfoContainer((IResource)newProject)).getCode() != 0) {
            PTPUIPlugin.log((IStatus)initResult);
        }
        monitor.done();
    }

    public void setIndexer(IProject newProject, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Setting indexer", 2);
        if ("org.eclipse.cdt.core.CIndexer" != null && newProject != null) {
            ICDescriptorOperation op = new ICDescriptorOperation(){

                public void execute(ICDescriptor descriptor, IProgressMonitor monitor) throws CoreException {
                    descriptor.remove("org.eclipse.cdt.core.CIndexer");
                    descriptor.create("org.eclipse.cdt.core.CIndexer", "org.eclipse.cdt.core.CIndexer");
                    monitor.worked(1);
                }
            };
            CCorePlugin.getDefault().getCDescriptorManager().runDescriptorOperation(newProject, op, monitor);
        }
        monitor.done();
    }
}

