/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.ui.actions.GotoAction;
import org.eclipse.ptp.ui.actions.GotoDropDownAction;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.views.AbstractParallelElementView;
import org.eclipse.ptp.ui.views.ParallelJobView;

public class ChangeJobViewAction
extends GotoDropDownAction {
    public static final String name = "Job View";

    public ChangeJobViewAction(AbstractParallelElementView view) {
        super(name, view);
        this.setImageDescriptor(ParallelImages.ID_ICON_JOB_NORMAL);
    }

    protected void createDropDownMenu(MenuManager dropDownMenuMgr) {
        if (this.view instanceof ParallelJobView) {
            ParallelJobView jView = (ParallelJobView)this.view;
            String current_view = jView.getCurrentView();
            this.addAction(dropDownMenuMgr, "Both", "0", current_view);
            this.addAction(dropDownMenuMgr, "Job", "1", current_view);
            this.addAction(dropDownMenuMgr, "Process", "2", current_view);
        }
    }

    protected void addAction(MenuManager dropDownMenuMgr, String view_name, String id, String curID) {
        InternalJobAction action = new InternalJobAction(view_name, id, this.getViewPart(), (GotoDropDownAction)this);
        action.setChecked(curID.equals(id));
        action.setEnabled(true);
        dropDownMenuMgr.add((IAction)action);
    }

    public void run(IElement[] elements) {
    }

    public void run() {
        if (this.view instanceof ParallelJobView) {
            ParallelJobView jView = (ParallelJobView)this.view;
            String current_view = jView.getCurrentView();
            if (current_view.equals("0")) {
                this.run(null, "1");
            } else if (current_view.equals("1")) {
                this.run(null, "2");
            } else {
                this.run(null, "0");
            }
        }
    }

    public void run(IElement[] elements, String id) {
        if (this.view instanceof ParallelJobView) {
            ParallelJobView jView = (ParallelJobView)this.view;
            jView.changeView(id);
        }
    }

    private class InternalJobAction
    extends GotoAction {
        public InternalJobAction(String name, String id, AbstractParallelElementView view, GotoDropDownAction action) {
            super(name, id, view, action);
            this.setImageDescriptor(ParallelImages.ID_ICON_JOB_NORMAL);
        }
    }
}

