/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.ui.actions.GotoAction;
import org.eclipse.ptp.ui.actions.GotoDropDownAction;
import org.eclipse.ptp.ui.managers.MachineManager;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.views.AbstractParallelElementView;
import org.eclipse.ptp.ui.views.ParallelMachineView;

public class ChangeMachineAction
extends GotoDropDownAction {
    public static final String name = "Machine";

    public ChangeMachineAction(AbstractParallelElementView view) {
        super(name, view);
        this.setImageDescriptor(ParallelImages.ID_ICON_MACHINE_NORMAL);
    }

    protected void createDropDownMenu(MenuManager dropDownMenuMgr) {
        if (this.view instanceof ParallelMachineView) {
            ParallelMachineView pmView = (ParallelMachineView)this.view;
            String curMachineID = pmView.getCurrentID();
            IPMachine[] macs = ((MachineManager)pmView.getUIManager()).getMachines();
            int i = 0;
            while (i < macs.length) {
                this.addAction(dropDownMenuMgr, macs[i].getName(), macs[i].getIDString(), curMachineID);
                ++i;
            }
        }
    }

    protected void addAction(MenuManager dropDownMenuMgr, String machine_name, String id, String curID) {
        InternalMachineAction action = new InternalMachineAction(machine_name, id, this.getViewPart(), (GotoDropDownAction)this);
        action.setChecked(curID.equals(id));
        action.setEnabled(true);
        dropDownMenuMgr.add((IAction)action);
    }

    public void run(IElement[] elements) {
    }

    public void run() {
        if (this.view instanceof ParallelMachineView) {
            ParallelMachineView pmView = (ParallelMachineView)this.view;
            IPMachine[] macs = ((MachineManager)pmView.getUIManager()).getMachines();
            int i = 0;
            while (i < macs.length) {
                if (pmView.getCurrentID().equals(macs[i].getIDString())) {
                    if (i + 1 < macs.length) {
                        this.run(null, macs[i + 1].getIDString());
                        break;
                    }
                    this.run(null, macs[0].getIDString());
                    break;
                }
                ++i;
            }
        }
    }

    public void run(IElement[] elements, String id) {
        if (this.view instanceof ParallelMachineView) {
            ParallelMachineView pmView = (ParallelMachineView)this.view;
            pmView.selectMachine(id);
            pmView.update();
            pmView.refresh(false);
        }
    }

    private class InternalMachineAction
    extends GotoAction {
        public InternalMachineAction(String name, String id, AbstractParallelElementView view, GotoDropDownAction action) {
            super(name, id, view, action);
            this.setImageDescriptor(ParallelImages.ID_ICON_MACHINE_NORMAL);
        }
    }
}

