/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.ui.actions.GotoAction;
import org.eclipse.ptp.ui.actions.GotoDropDownAction;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.views.AbstractParallelElementView;

public class ChangeSetAction
extends GotoDropDownAction {
    public static final String name = "Change Set";

    public ChangeSetAction(AbstractParallelElementView view) {
        super(name, view);
        this.setImageDescriptor(ParallelImages.ID_ICON_CHANGESET_NORMAL);
    }

    protected void createDropDownMenu(MenuManager dropDownMenuMgr) {
        String curID = this.view.getCurrentSetID();
        if (curID == null || curID.length() == 0) {
            return;
        }
        this.addAction(dropDownMenuMgr, "Root", "Root", curID);
        IElementHandler setManager = this.view.getCurrentElementHandler();
        if (setManager == null) {
            return;
        }
        IElementSet[] sets = setManager.getSortedSets();
        if (sets.length > 1) {
            dropDownMenuMgr.add((IContributionItem)new Separator());
        }
        int i = 0;
        while (i < sets.length) {
            if (!sets[i].getID().equals("Root")) {
                this.addAction(dropDownMenuMgr, sets[i].getID(), sets[i].getID(), curID);
            }
            ++i;
        }
    }

    protected void addAction(MenuManager dropDownMenuMgr, String e_name, String id, String curID) {
        InternalSetAction action = new InternalSetAction(e_name, id, this.view, (GotoDropDownAction)this);
        action.setChecked(curID.equals(id));
        action.setEnabled(true);
        dropDownMenuMgr.add((IAction)action);
    }

    public void run(IElement[] elements) {
    }

    public void run() {
        IElementHandler setManager = this.view.getCurrentElementHandler();
        if (setManager == null) {
            return;
        }
        IElementSet[] sets = setManager.getSortedSets();
        int i = 0;
        while (i < sets.length) {
            if (this.view.getCurrentSetID().equals(sets[i].getID())) {
                if (i + 1 < sets.length) {
                    this.run(null, sets[i + 1]);
                    break;
                }
                this.run(null, sets[0]);
                break;
            }
            ++i;
        }
    }

    public void run(IElement[] elements, IElementSet set) {
        this.view.selectSet(set);
        this.view.update();
        this.view.refresh(false);
    }

    public void run(IElement[] elements, String id) {
        IElementHandler setManager = this.view.getCurrentElementHandler();
        if (setManager == null) {
            return;
        }
        this.run(elements, setManager.getSet(id));
    }

    private class InternalSetAction
    extends GotoAction {
        public InternalSetAction(String name, String id, AbstractParallelElementView view, GotoDropDownAction action) {
            super(name, id, view, action);
        }
    }
}

