/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.ui.actions.GotoAction;
import org.eclipse.ptp.ui.actions.GotoDropDownAction;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.views.AbstractParallelElementView;

public class CreateSetAction
extends GotoDropDownAction {
    public static final String name = "Create Set";

    public CreateSetAction(AbstractParallelElementView view) {
        super(name, view);
        this.setImageDescriptor(ParallelImages.ID_ICON_CREATESET_NORMAL);
    }

    protected void createDropDownMenu(MenuManager dropDownMenuMgr) {
        String curID = this.view.getCurrentSetID();
        IElementHandler setManager = this.view.getCurrentElementHandler();
        if (setManager == null) {
            return;
        }
        IElementSet[] sets = setManager.getSortedSets();
        int i = 1;
        while (i < sets.length) {
            this.addAction(dropDownMenuMgr, sets[i].getID(), sets[i].getID(), curID);
            ++i;
        }
    }

    protected void addAction(MenuManager dropDownMenuMgr, String e_name, String id, String curID) {
        InternalSetAction action = new InternalSetAction("Add to set: " + e_name, id, this.view, (GotoDropDownAction)this);
        action.setEnabled(!curID.equals(id));
        dropDownMenuMgr.add((IAction)action);
    }

    public void run(IElement[] elements) {
        this.run(elements, null);
    }

    public void run(IElement[] elements, String setID) {
        if (this.validation(elements)) {
            final IElementHandler setManager = this.view.getCurrentElementHandler();
            if (setManager == null) {
                return;
            }
            if (setID == null) {
                IInputValidator inputValidator = new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText == null || newText.length() == 0) {
                            return "This field cannot be empty.";
                        }
                        if (setManager.contains(newText)) {
                            return "Entered set name (" + newText + ") is already used.";
                        }
                        return null;
                    }
                };
                InputDialog inputDialog = new InputDialog(this.getShell(), "Create a new set name", "Please enter the new set name.", "", inputValidator);
                if (inputDialog.open() == 1) {
                    return;
                }
                String name = inputDialog.getValue();
                setID = this.view.getUIManager().createSet(elements, name, name, setManager);
            } else {
                this.view.getUIManager().addToSet(elements, setID, setManager);
            }
            this.view.selectSet(setManager.getSet(setID));
            this.view.update();
            this.view.refresh(false);
        }
    }

    private class InternalSetAction
    extends GotoAction {
        public InternalSetAction(String name, String id, AbstractParallelElementView view, GotoDropDownAction action) {
            super(name, id, view, action);
            this.setImageDescriptor(ParallelImages.ID_ICON_CREATESET_NORMAL);
        }
    }
}

