/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.actions;

import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.ui.IManager;
import org.eclipse.ptp.ui.UIUtils;
import org.eclipse.ptp.ui.actions.ParallelAction;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.views.AbstractParallelElementView;

public class DeleteSetAction
extends ParallelAction {
    public static final String name = "Delete Set";

    public DeleteSetAction(AbstractParallelElementView view) {
        super(name, view);
        this.setImageDescriptor(ParallelImages.ID_ICON_DELETESET_NORMAL);
    }

    public void run(IElement[] elements) {
    }

    public void run() {
        IElementSet set = this.view.getCurrentSet();
        if (set != null && set.size() > 0) {
            IElementHandler setManager = this.view.getCurrentElementHandler();
            if (setManager == null) {
                return;
            }
            if (UIUtils.showQuestionDialog("Delete Set " + set.getID() + " Confirmation", "Are you sure you want to delete all elements from this set?")) {
                IManager uiManager = this.view.getUIManager();
                uiManager.removeSet(set.getID(), setManager);
                IElementSet[] sets = setManager.getSortedSets();
                if (sets.length > 0) {
                    IElementSet lastSet = sets[sets.length - 1];
                    this.view.selectSet(setManager.getSet(lastSet.getID()));
                    this.view.update();
                    this.view.refresh(false);
                }
            }
        }
    }
}

