/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.adapters;

import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class PMachinePropertySource
implements IPropertySource {
    private final IPMachine pmachine;
    private final PropertyDescriptor[] descriptors;

    public PMachinePropertySource(IPMachine pmachine) {
        this.pmachine = pmachine;
        String[] keys = pmachine.getAttributeKeys();
        this.descriptors = new PropertyDescriptor[keys.length + 2];
        this.descriptors[0] = new PropertyDescriptor((Object)"name", "name");
        this.descriptors[1] = new PropertyDescriptor((Object)"numNodes", "numNodes");
        int i = 0;
        while (i < keys.length) {
            this.descriptors[i + 2] = new PropertyDescriptor((Object)keys[i], keys[i]);
            ++i;
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        if ("name".equals(id)) {
            return this.pmachine.getElementName();
        }
        if ("numNodes".equals(id)) {
            return Integer.toString(this.pmachine.getNodes().length);
        }
        return this.pmachine.getAttribute(id.toString());
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

