/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.adapters;

import java.util.ArrayList;
import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ptp.core.IPUniverse;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ResourceManagerPropertySource
implements IPropertySource {
    private final IResourceManager resourceManager;
    private final PropertyDescriptor[] descriptors;

    public ResourceManagerPropertySource(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(new PropertyDescriptor((Object)"name", "name"));
        descriptors.add(new PropertyDescriptor((Object)"description", "description"));
        descriptors.add(new PropertyDescriptor((Object)"type", "type"));
        descriptors.add(new PropertyDescriptor((Object)"status", "status"));
        descriptors.add(new PropertyDescriptor((Object)"machines", "machines"));
        this.descriptors = descriptors.toArray(new PropertyDescriptor[descriptors.size()]);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        if ("name".equals(id)) {
            return this.resourceManager.getConfiguration().getName();
        }
        if ("description".equals(id)) {
            return this.resourceManager.getConfiguration().getDescription();
        }
        if ("type".equals(id)) {
            String resourceManagerId = this.resourceManager.getConfiguration().getResourceManagerId();
            PTPCorePlugin plugin = PTPCorePlugin.getDefault();
            IResourceManagerFactory factory = plugin.getResourceManagerFactory(resourceManagerId);
            return factory.getName();
        }
        if ("status".equals(id)) {
            return this.resourceManager.getStatus().toString();
        }
        if ("machines".equals(id)) {
            IPUniverse universe = this.resourceManager.getModelPresentation().getUniverse();
            IPMachine[] machines = universe.getMachines();
            return Integer.toString(machines.length);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

