/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.dialogs;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ResourceManagerDialog
extends TitleAreaDialog {
    private static final int COLUMN_DESC = 2;
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_TYPE = 1;
    private static final String NO_MANAGER = "No Manager";
    private final Set addedManagers = new HashSet();
    private final Map factories = new HashMap();
    private final Set orignalResourceManagers = new HashSet();
    private final Set removedManagers = new HashSet();
    private TableViewer tableViewer;
    private final String[] factIds;
    private Combo combo;

    public ResourceManagerDialog(Shell parentShell, IResourceManagerFactory[] factories, IResourceManager[] originalResourceManagers) {
        super(parentShell);
        int i = 0;
        while (i < factories.length) {
            this.factories.put(factories[i].getId(), factories[i]);
            ++i;
        }
        this.orignalResourceManagers.addAll((Collection)Arrays.asList(originalResourceManagers));
        this.factIds = this.factories.keySet().toArray(new String[0]);
    }

    public IResourceManager[] getAddedManagers() {
        return this.addedManagers.toArray(new IResourceManager[this.addedManagers.size()]);
    }

    public IResourceManager[] getRemovedManagers() {
        return this.removedManagers.toArray(new IResourceManager[this.removedManagers.size()]);
    }

    private void addResourceManager() {
        int selectionIndex = this.combo.getSelectionIndex();
        IResourceManager addedManager = this.createResourceManager(this.factIds[selectionIndex]);
        if (addedManager != null) {
            this.addedManagers.add(addedManager);
        }
    }

    private IResourceManager createResourceManager(String string) {
        return null;
    }

    private IResourceManagerFactory getFactory(String resourceManagerId) {
        return (IResourceManagerFactory)this.factories.get(resourceManagerId);
    }

    private Set getResultingSet() {
        HashSet<String> resulting = new HashSet<String>(this.orignalResourceManagers);
        resulting.addAll(this.addedManagers);
        resulting.removeAll(this.removedManagers);
        if (resulting.size() == 0) {
            resulting.add(NO_MANAGER);
        }
        return resulting;
    }

    private void removeResourceManagers() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        this.addedManagers.removeAll(selection.toList());
        this.removedManagers.addAll(selection.toList());
        this.removedManagers.retainAll(this.orignalResourceManagers);
        this.tableViewer.refresh();
    }

    protected void cancelPressed() {
        this.addedManagers.clear();
        this.removedManagers.clear();
        super.cancelPressed();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setMessage("Add and Remove Resource Managers");
        this.setTitle("Resource Managers");
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(composite, 0);
        contents.setLayout((Layout)new GridLayout(3, false));
        Composite leftSide = new Composite(contents, 0);
        leftSide.setLayout((Layout)new GridLayout(1, false));
        leftSide.setLayoutData((Object)new GridData(770));
        Label titleBarSeparator = new Label(contents, 514);
        titleBarSeparator.setLayoutData((Object)new GridData(1040));
        Composite rightSide = new Composite(contents, 0);
        rightSide.setLayout((Layout)new GridLayout(1, false));
        rightSide.setLayoutData((Object)new GridData(770));
        this.tableViewer = new TableViewer(leftSide, 66306);
        Button removeButton = new Button(leftSide, 8);
        removeButton.setText("Remove");
        Label addLabel = new Label(rightSide, 0);
        addLabel.setText("Add Resource Manager of Selected Type");
        this.combo = new Combo(rightSide, 12);
        this.combo.setLayoutData((Object)new GridData(300, -1));
        String[] factNames = new String[this.factIds.length];
        int i = 0;
        while (i < factNames.length) {
            factNames[i] = this.getFactory(this.factIds[i]).getName();
            ++i;
        }
        this.combo.setItems(factNames);
        this.combo.setText(factNames[0]);
        Button addButton = new Button(rightSide, 8);
        addButton.setText("Add");
        this.tableViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LableProvider());
        Table table = this.tableViewer.getTable();
        new TableColumn(table, 16384).setText("Name");
        new TableColumn(table, 16384).setText("Type");
        new TableColumn(table, 16384).setText("Description");
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.getColumn(0).setWidth(100);
        table.getColumn(1).setWidth(200);
        table.getColumn(2).setWidth(300);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ResourceManagerDialog.this.addResourceManager();
            }
        });
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ResourceManagerDialog.this.removeResourceManagers();
            }
        });
        this.tableViewer.setInput((Object)this);
        this.tableViewer.getControl().setFocus();
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public class ContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            Set elements = ResourceManagerDialog.this.getResultingSet();
            return elements.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class LableProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == ResourceManagerDialog.NO_MANAGER) {
                return this.getText("none");
            }
            IResourceManager manager = (IResourceManager)element;
            IResourceManagerConfiguration configuration = manager.getConfiguration();
            IResourceManagerFactory factory = ResourceManagerDialog.this.getFactory(configuration.getResourceManagerId());
            switch (columnIndex) {
                case 0: {
                    return this.getText(configuration.getName());
                }
                case 1: {
                    return this.getText(factory.getName());
                }
                case 2: {
                    return this.getText(configuration.getDescription());
                }
            }
            return this.getText("");
        }
    }
}

