/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.core.IPElement;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.internal.ui.adapters.PropertyAdapterFactory;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ptp.ui.managers.JobManager;
import org.eclipse.ptp.ui.managers.MachineManager;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizardPageFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PTPUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.ui";
    private static PTPUIPlugin plugin;
    private ResourceBundle resourceBundle;
    private final HashMap configurationWizardPageFactories = new HashMap();
    private MachineManager machineManager = null;
    private JobManager jobManager = null;
    private List jobList = Collections.synchronizedList(new ArrayList());
    private IJobChangeListener jlistener = new IJobChangeListener(){

        public void sleeping(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
        }

        public void running(IJobChangeEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            List list = PTPUIPlugin.this.jobList;
            synchronized (list) {
                Job job2 = event.getJob();
                if (!job2.getResult().isOK()) {
                    for (Job job2 : PTPUIPlugin.this.jobList) {
                        job2.cancel();
                        job2.removeJobChangeListener((IJobChangeListener)this);
                    }
                    PTPUIPlugin.this.jobList.clear();
                } else {
                    PTPUIPlugin.this.jobList.remove(job2);
                    job2.removeJobChangeListener((IJobChangeListener)this);
                    if (PTPUIPlugin.this.jobList.size() > 0) {
                        job2 = (Job)PTPUIPlugin.this.jobList.get(0);
                        job2.schedule();
                    }
                }
            }
        }

        public void awake(IJobChangeEvent event) {
        }

        public void aboutToRun(IJobChangeEvent event) {
        }
    };

    public PTPUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registerAdapterFactories();
        this.retrieveConfigurationWizardPageFactories();
        this.machineManager = new MachineManager();
        this.jobManager = new JobManager();
    }

    private void registerAdapterFactories() {
        IAdapterManager manager = Platform.getAdapterManager();
        PropertyAdapterFactory factory = new PropertyAdapterFactory();
        manager.registerAdapters((IAdapterFactory)factory, IResourceManager.class);
        manager.registerAdapters((IAdapterFactory)factory, IPElement.class);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.machineManager.shutdown();
        this.jobManager.shutdown();
        this.machineManager = null;
        this.jobManager = null;
        plugin = null;
        this.resourceBundle = null;
        this.jobList.clear();
    }

    public RMConfigurationWizardPageFactory getRMConfigurationWizardPageFactory(IResourceManagerFactory factory) {
        return (RMConfigurationWizardPageFactory)this.configurationWizardPageFactories.get(factory.getClass().getName());
    }

    public static String getUniqueIdentifier() {
        if (PTPUIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public MachineManager getMachineManager() {
        return this.machineManager;
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    public static PTPUIPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PTPUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ptp.ui.UIPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PTPUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = PTPUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public String getPluginPath() {
        try {
            return Platform.resolve((URL)Platform.getBundle((String)PLUGIN_ID).getEntry("/")).getPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PTPUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static Shell getShell() {
        if (PTPUIPlugin.getActiveWorkbenchWindow() != null) {
            return PTPUIPlugin.getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    public String getCurrentPerspectiveID() {
        return PTPUIPlugin.getActiveWorkbenchWindow().getActivePage().getPerspective().getId();
    }

    public void addPersepectiveListener(IPerspectiveListener listener) {
        PTPUIPlugin.getActiveWorkbenchWindow().addPerspectiveListener(listener);
    }

    public void removePersepectiveListener(IPerspectiveListener listener) {
        PTPUIPlugin.getActiveWorkbenchWindow().removePerspectiveListener(listener);
    }

    public static void log(String msg) {
        PTPUIPlugin.log((IStatus)new Status(4, PTPUIPlugin.getUniqueIdentifier(), 4, msg, null));
    }

    public static void log(IStatus status) {
        PTPUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        PTPUIPlugin.log((IStatus)new Status(4, PTPUIPlugin.getUniqueIdentifier(), 150, "Internal Error", e));
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
        } else {
            status = new Status(4, PTPUIPlugin.getUniqueIdentifier(), 150, "Error within PTP UI: ", t);
            PTPUIPlugin.log(status);
        }
        PTPUIPlugin.errorDialog(shell, title, message, status);
    }

    public static void errorDialog(Shell shell, String title, IStatus s) {
        PTPUIPlugin.errorDialog(shell, title, s.getMessage(), s);
    }

    public static void errorDialog(Shell shell, String title, String message, IStatus s) {
        if (s != null && message != null && message.equals(s.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)s);
    }

    public void refreshRuntimeSystem(boolean queue, boolean force) {
        if (queue) {
            this.refreshRuntimeSystemInQueue(PTPUIPlugin.getShell(), force);
        } else {
            this.refreshRuntimeSystemNow(PTPUIPlugin.getShell(), force);
        }
    }

    private boolean refreshRuntimeSystemNow(Shell shell, final boolean force) {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        PTPCorePlugin.getDefault().getModelPresentation().refreshRuntimeSystems(monitor, force);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            return true;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            ErrorDialog.openError((Shell)shell, (String)"Refresh runtime system error", (String)e.getMessage(), (IStatus)new Status(4, PTPUIPlugin.getUniqueIdentifier(), 150, e.getMessage(), e.getTargetException()));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshRuntimeSystemInQueue(Shell shell, final boolean force) {
        List list = this.jobList;
        synchronized (list) {
            Job job = new Job("Refresh runtime system"){

                public IStatus run(IProgressMonitor monitor) {
                    if (!monitor.isCanceled()) {
                        try {
                            PTPCorePlugin.getDefault().getModelPresentation().refreshRuntimeSystems(monitor, force);
                        }
                        catch (CoreException e) {
                            return e.getStatus();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(10);
            job.addJobChangeListener(this.jlistener);
            PlatformUI.getWorkbench().getProgressService().showInDialog(shell, job);
            this.jobList.add(job);
            if (this.jobList.size() == 1) {
                job.schedule();
            }
        }
    }

    private void retrieveConfigurationWizardPageFactories() {
        System.out.println("In retrieveConfigurationWizardPageFactories");
        this.configurationWizardPageFactories.clear();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.ui.rmconfiguration");
        IExtension[] extensions = extensionPoint.getExtensions();
        int iext = 0;
        while (iext < extensions.length) {
            IExtension ext = extensions[iext];
            IConfigurationElement[] elements = ext.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement ce = elements[i];
                try {
                    RMConfigurationWizardPageFactory factory = (RMConfigurationWizardPageFactory)ce.createExecutableExtension("class");
                    Class rmFactoryClass = factory.getRMFactoryClass();
                    this.configurationWizardPageFactories.put(rmFactoryClass.getName(), factory);
                    System.out.println("wizard page factory: " + factory + " for class: " + rmFactoryClass);
                }
                catch (CoreException e) {
                    PTPUIPlugin.log(e);
                }
                ++i;
            }
            ++iext;
        }
        System.out.println("leaving retrieveConfigurationWizardPageFactories");
    }
}

