/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerMenuContribution;
import org.eclipse.ptp.rmsystem.ResourceManagerStatus;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class StartResourceManagersObjectActionDelegate
implements IObjectActionDelegate,
IActionDelegate2 {
    private Shell targetShell;
    private IResourceManagerMenuContribution[] menuContribs;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetShell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        System.out.println("StartResourceManagerObjectActionDelegate.run");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object[] selections = ss.toArray();
        this.menuContribs = new IResourceManagerMenuContribution[selections.length];
        System.arraycopy(selections, 0, this.menuContribs, 0, this.menuContribs.length);
    }

    public void dispose() {
    }

    public void init(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        int i = 0;
        while (i < this.menuContribs.length) {
            IResourceManagerMenuContribution menuContrib = this.menuContribs[i];
            IResourceManager rmManager = (IResourceManager)menuContrib.getAdapter(IResourceManager.class);
            if (rmManager.getStatus().equals(ResourceManagerStatus.STARTED)) {
                MessageDialog.openInformation((Shell)this.targetShell, (String)"Resource Manager Already Started", (String)("Resource Manager \"" + rmManager.getConfiguration().getName() + "\" Already Started"));
                return;
            }
            try {
                rmManager.start();
            }
            catch (CoreException e) {
                String message = "Unable to start ResourceManager \"" + rmManager.getConfiguration().getName() + "\"";
                Status status = new Status(4, "org.eclipse.ptp.ui", 1, message, (Throwable)e);
                ErrorDialog dlg = new ErrorDialog(this.targetShell, "Error Starting Resource Manager", message, (IStatus)status, 4);
                dlg.open();
                PTPUIPlugin.log((IStatus)status);
            }
            ++i;
        }
    }
}

