/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.managers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ptp.core.IModelPresentation;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPUniverse;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.ui.IManager;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.listeners.IJobChangedListener;
import org.eclipse.ptp.ui.listeners.ISetListener;
import org.eclipse.ptp.ui.model.ElementSet;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractUIManager
implements IManager {
    protected IModelPresentation modelPresentation = null;
    protected String cur_set_id = "";
    protected ListenerList setListeners = new ListenerList();
    protected static ListenerList jListeners = new ListenerList();

    public AbstractUIManager() {
        this.modelPresentation = PTPCorePlugin.getDefault().getModelPresentation();
    }

    public void shutdown() {
        if (this.setListeners != null) {
            this.setListeners.clear();
            this.setListeners = null;
        }
        if (jListeners != null) {
            jListeners.clear();
            jListeners = null;
        }
    }

    public void addSetListener(ISetListener setListener) {
        this.setListeners.add((Object)setListener);
    }

    public void removeSetListener(ISetListener setListener) {
        this.setListeners.remove((Object)setListener);
    }

    public void fireSetEvent(final int eventType, final IElement[] elements, final IElementSet cur_set, final IElementSet pre_set) {
        Object[] array = this.setListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final ISetListener setListener = (ISetListener)array[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    switch (eventType) {
                        case 0: {
                            setListener.createSetEvent(cur_set, elements);
                            break;
                        }
                        case 1: {
                            setListener.deleteSetEvent(cur_set);
                            break;
                        }
                        case 2: {
                            setListener.changeSetEvent(cur_set, pre_set);
                            break;
                        }
                        case 3: {
                            setListener.addElementsEvent(cur_set, elements);
                            break;
                        }
                        case 4: {
                            setListener.removeElementsEvent(cur_set, elements);
                        }
                    }
                }
            });
            ++i;
        }
    }

    public void addJobChangedListener(IJobChangedListener jobListener) {
        jListeners.add((Object)jobListener);
    }

    public void removeJobChangedListener(IJobChangedListener jobListener) {
        jListeners.remove((Object)jobListener);
    }

    public void fireJobChangedEvent(final int type, final String cur_job_id, final String pre_job_id) {
        Object[] array = jListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final IJobChangedListener listener = (IJobChangedListener)array[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.jobChangedEvent(type, cur_job_id, pre_job_id);
                }
            });
            ++i;
        }
    }

    public void addToSet(IElement[] elements, IElementSet set) {
        int i = 0;
        while (i < elements.length) {
            set.add(elements[i]);
            ++i;
        }
    }

    public void addToSet(IElement[] elements, String setID, IElementHandler elementHandler) {
        IElementSet set = elementHandler.getSet(setID);
        this.addToSet(elements, set);
        this.updateMatchElementSets(set, elementHandler);
        this.fireSetEvent(3, elements, set, null);
    }

    public String createSet(IElement[] elements, String setID, String setName, IElementHandler elementHandler) {
        ElementSet set = new ElementSet(elementHandler, setID, setName);
        this.addToSet(elements, set);
        elementHandler.add(set);
        this.updateMatchElementSets(set, elementHandler);
        this.fireSetEvent(0, elements, set, null);
        return set.getID();
    }

    public void removeSet(String setID, IElementHandler elementHandler) {
        IElementSet set = elementHandler.getSet(setID);
        String[] sets = set.getMatchSets();
        int i = 0;
        while (i < sets.length) {
            elementHandler.getSet(sets[i]).removeMatchSet(setID);
            ++i;
        }
        elementHandler.remove(setID);
        this.fireSetEvent(1, null, set, null);
    }

    public void removeFromSet(IElement[] elements, String setID, IElementHandler elementHandler) {
        IElementSet set = elementHandler.getSet(setID);
        int i = 0;
        while (i < elements.length) {
            set.remove(elements[i]);
            ++i;
        }
        this.updateMatchElementSets(set, elementHandler);
        this.fireSetEvent(4, elements, set, null);
    }

    public void updateMatchElementSets(IElementSet targetSet, IElementHandler elementHandler) {
        IElementSet[] sets = elementHandler.getSortedSets();
        int i = 0;
        while (i < sets.length) {
            if (!sets[i].getID().equals(targetSet.getID())) {
                IElement[] elements = sets[i].getElements();
                int j = 0;
                while (j < elements.length) {
                    if (targetSet.contains(elements[j].getID())) {
                        targetSet.addMatchSet(sets[i].getID());
                        sets[i].addMatchSet(targetSet.getID());
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public boolean isNoJob(String jid) {
        return jid == null || jid.length() == 0;
    }

    public boolean isJobStop(String job_id) {
        if (this.isNoJob(job_id)) {
            return true;
        }
        IPJob job = this.findJobById(job_id);
        return job == null || job.isAllStop();
    }

    public IPJob findJob(String job_name) {
        IPUniverse universe = this.modelPresentation.getUniverse();
        if (universe == null) {
            return null;
        }
        return universe.findJobByName(job_name);
    }

    public IPJob findJobById(String job_id) {
        if (job_id == null) {
            return null;
        }
        IPUniverse universe = this.modelPresentation.getUniverse();
        if (universe == null) {
            return null;
        }
        IPJob job = universe.findJobById(job_id);
        return job;
    }

    public void removeJob(IPJob job) {
        IPUniverse universe = this.modelPresentation.getUniverse();
        if (universe != null) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunch[] launches = launchManager.getLaunches();
            int i = 0;
            while (i < launches.length) {
                if (launches[i].getAttribute("JOB_ID").equals(job.getIDString())) {
                    launchManager.removeLaunch(launches[i]);
                }
                ++i;
            }
            universe.deleteJob(job);
            this.fireJobChangedEvent(1, null, job.getIDString());
        }
    }

    public void removeAllStoppedJobs() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pmonitor) throws InvocationTargetException {
                if (pmonitor == null) {
                    pmonitor = new NullProgressMonitor();
                }
                try {
                    IPUniverse universe = AbstractUIManager.this.modelPresentation.getUniverse();
                    if (universe != null) {
                        IPJob[] jobs = universe.getJobs();
                        pmonitor.beginTask("Removing stopped jobs...", jobs.length);
                        int i = 0;
                        while (i < jobs.length) {
                            if (pmonitor.isCanceled()) {
                                throw new InvocationTargetException(new Exception("Cancelled by user"));
                            }
                            if (jobs[i].isAllStop()) {
                                AbstractUIManager.this.removeJob(jobs[i]);
                            }
                            pmonitor.worked(1);
                            ++i;
                        }
                    }
                }
                finally {
                    pmonitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InterruptedException e) {
            PTPUIPlugin.log(e);
        }
        catch (InvocationTargetException e1) {
            PTPUIPlugin.log(e1);
        }
    }

    public boolean hasStoppedJob() {
        IPUniverse universe = this.modelPresentation.getUniverse();
        if (universe == null) {
            return false;
        }
        IPJob[] jobs = universe.getJobs();
        int i = 0;
        while (i < jobs.length) {
            if (jobs[i].isAllStop()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getStatus(IElement element) {
        return this.getStatus(element.getID());
    }
}

