/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.managers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.IPUniverse;
import org.eclipse.ptp.ui.managers.AbstractUIManager;
import org.eclipse.ptp.ui.model.Element;
import org.eclipse.ptp.ui.model.ElementHandler;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;

public class JobManager
extends AbstractUIManager {
    protected Map jobList = new HashMap();
    protected String cur_job_id = "";

    public void shutdown() {
        this.clear();
        this.modelPresentation = null;
        super.shutdown();
    }

    public IElementHandler getElementHandler(String id) {
        return (IElementHandler)this.jobList.get(id);
    }

    public int size() {
        return this.jobList.size();
    }

    public void clear() {
        if (this.jobList != null) {
            this.jobList.clear();
        }
    }

    public IPJob[] getJobs() {
        IPUniverse universe = this.modelPresentation.getUniverse();
        if (universe == null) {
            return new IPJob[0];
        }
        return universe.getSortedJobs();
    }

    public IPJob getCurrentJob() {
        return this.findJobById(this.getCurrentJobId());
    }

    public String getCurrentJobId() {
        return this.cur_job_id;
    }

    public void setCurrentJobId(String job_id) {
        String tmp_jod_id = this.cur_job_id;
        this.cur_job_id = job_id;
        this.fireJobChangedEvent(0, job_id, tmp_jod_id);
    }

    public String getCurrentSetId() {
        return this.cur_set_id;
    }

    public void setCurrentSetId(String set_id) {
        this.cur_set_id = set_id;
    }

    public String getProcessStatusText(IPProcess proc) {
        switch (this.getProcessStatus(proc)) {
            case 4: {
                return "Starting";
            }
            case 3: {
                return "Running";
            }
            case 1: {
                return "Exited";
            }
            case 2: {
                return "Exited Signal";
            }
            case 5: {
                return "Stopped";
            }
            case 0: {
                return "Error";
            }
        }
        return "Error";
    }

    public int getStatus(String id) {
        return this.getStatus(this.getCurrentJobId(), Integer.parseInt(id));
    }

    public int getStatus(String job_id, int task_id) {
        return this.getProcessStatus(this.findProcess(job_id, task_id));
    }

    public int getProcessStatus(IPProcess proc) {
        if (proc != null) {
            String status = proc.getStatus();
            if (status.equals("starting")) {
                return 4;
            }
            if (status.equals("running")) {
                return 3;
            }
            if (status.equals("exited")) {
                return 1;
            }
            if (status.equals("exited-signalled")) {
                return 2;
            }
            if (status.equals("stopped")) {
                return 5;
            }
            if (status.equals("error")) {
                return 0;
            }
        }
        return 0;
    }

    public IPProcess findProcess(String job_id, int task_id) {
        return this.findProcess(this.findJobById(job_id), task_id);
    }

    public IPProcess findProcess(IPJob job, int task_id) {
        if (job == null) {
            return null;
        }
        return job.findProcessByTaskId(task_id);
    }

    public String getName(String id) {
        IPJob job = this.findJobById(id);
        if (job == null) {
            return "";
        }
        return job.getName();
    }

    protected IElement createElement(IElementSet set, String key, String name) {
        return new Element(set, key, name);
    }

    public void addJob(IPJob job) {
        IPProcess[] pProcesses;
        int total_element;
        if (!this.jobList.containsKey(job.getIDString()) && (total_element = (pProcesses = job.getSortedProcesses()).length) > 0) {
            ElementHandler elementHandler = new ElementHandler();
            IElementSet set = elementHandler.getSetRoot();
            int i = 0;
            while (i < total_element) {
                set.add(this.createElement(set, String.valueOf(pProcesses[i].getTaskId()), pProcesses[i].getIDString()));
                ++i;
            }
            elementHandler.add(set);
            this.jobList.put(job.getIDString(), elementHandler);
        }
    }

    public String initial() {
        IPJob[] jobs = this.getJobs();
        String last_job_id = "";
        if (jobs.length > 0) {
            last_job_id = jobs[jobs.length - 1].getIDString();
            int j = 0;
            while (j < jobs.length) {
                this.addJob(jobs[j]);
                ++j;
            }
            this.setCurrentSetId("Root");
        }
        return last_job_id;
    }

    public String[] getSets(String jid) {
        IElementHandler eHandler = this.getElementHandler(jid);
        if (eHandler == null) {
            return new String[0];
        }
        IElementSet[] eSets = eHandler.getSets();
        String[] sets = new String[eSets.length];
        int i = 1;
        while (i < sets.length + 1) {
            String tmp = eSets[i - 1].getID();
            if (!tmp.equals("Root")) {
                if (i == sets.length) {
                    sets[i - 1] = tmp;
                } else {
                    sets[i] = tmp;
                }
            }
            ++i;
        }
        if (sets.length > 0) {
            sets[0] = "Root";
        }
        return sets;
    }

    public boolean isCurrentSetContainProcess(String jid, String processID) {
        if (!this.getCurrentJobId().equals(jid)) {
            return false;
        }
        IElementHandler elementHandler = this.getElementHandler(this.getCurrentJobId());
        if (elementHandler == null) {
            return false;
        }
        IElementSet set = elementHandler.getSet(this.getCurrentSetId());
        if (set == null) {
            return false;
        }
        return set.contains(processID);
    }

    public void terminateAll() throws CoreException {
        this.terminateAll(this.getCurrentJobId());
    }

    public void terminateAll(String job_id) throws CoreException {
        this.modelPresentation.abortJob(this.getName(job_id));
    }

    public void removeJob(IPJob job) {
        this.jobList.remove(job.getIDString());
        super.removeJob(job);
    }
}

