/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.managers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.core.IPUniverse;
import org.eclipse.ptp.ui.managers.AbstractUIManager;
import org.eclipse.ptp.ui.model.Element;
import org.eclipse.ptp.ui.model.ElementHandler;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;

public class MachineManager
extends AbstractUIManager {
    private Map machineList = new HashMap();
    protected String cur_machine_id = "";

    public void shutdown() {
        this.clear();
        this.modelPresentation = null;
        super.shutdown();
    }

    public boolean isNoMachine() {
        return this.isNoMachine(this.cur_machine_id);
    }

    public boolean isNoMachine(String machid) {
        return machid == null || machid.length() == 0;
    }

    public IElementHandler getElementHandler(String id) {
        return (IElementHandler)this.machineList.get(id);
    }

    public int size() {
        return this.machineList.size();
    }

    public void clear() {
        if (this.machineList != null) {
            this.cur_machine_id = "";
            this.machineList.clear();
        }
    }

    public IPMachine[] getMachines() {
        IPUniverse universe = this.modelPresentation.getUniverse();
        if (universe == null) {
            return new IPMachine[0];
        }
        return universe.getSortedMachines();
    }

    public String getCurrentMachineId() {
        return this.cur_machine_id;
    }

    public void setCurrentMachineId(String machine_id) {
        this.cur_machine_id = machine_id;
    }

    public String getCurrentSetId() {
        return this.cur_set_id;
    }

    public void setCurrentSetId(String set_id) {
        this.cur_set_id = set_id;
    }

    public String getNodeStatusText(IPNode node) {
        switch (this.getNodeStatus(node)) {
            case 0: {
                return "User Alloc Excl";
            }
            case 1: {
                return "User Alloc Shared";
            }
            case 2: {
                return "Other Alloc Excl";
            }
            case 3: {
                return "Other Alloc Shared";
            }
            case 9: {
                return "Up";
            }
            case 4: {
                return "Down";
            }
            case 5: {
                return "Error";
            }
            case 8: {
                return "Unknown";
            }
        }
        return "Unknown";
    }

    public String getNodeStatusText(String job_id, String proc_id) {
        return this.getNodeStatusText(this.findNode(job_id, proc_id));
    }

    public int getProcStatus(String p_state) {
        if (p_state.equals("starting")) {
            return 4;
        }
        if (p_state.equals("running")) {
            return 3;
        }
        if (p_state.equals("exited")) {
            return 1;
        }
        if (p_state.equals("exited-signalled")) {
            return 2;
        }
        if (p_state.equals("stopped")) {
            return 5;
        }
        if (p_state.equals("error")) {
            return 0;
        }
        return 0;
    }

    public int getNodeStatus(IPNode node) {
        if (node != null) {
            String nodeState = (String)node.getAttribute("Status");
            if (nodeState == null) {
                return 8;
            }
            if (nodeState.equals("up")) {
                if (node.getNumProcesses() > 0) {
                    return node.isAllStop() ? 6 : 7;
                }
                String nodeUser = (String)node.getAttribute("User Owner");
                String mode = (String)node.getAttribute("Mode");
                if (nodeUser != null) {
                    if (nodeUser.equals(System.getProperty("user.name"))) {
                        if (mode != null) {
                            if (mode.equals("64")) {
                                return 0;
                            }
                            if (mode.equals("72") || mode.equals("73") || mode.equals("65")) {
                                return 1;
                            }
                        }
                    } else if (mode != null) {
                        if (nodeUser.equals("root") && mode.equals("73")) {
                            return 9;
                        }
                        if (mode.equals("64")) {
                            return 2;
                        }
                        if (mode.equals("72") || mode.equals("73") || mode.equals("65")) {
                            return 3;
                        }
                    }
                }
                return 9;
            }
            if (nodeState.equals("down")) {
                return 4;
            }
            if (nodeState.equals("error")) {
                return 5;
            }
        }
        return 8;
    }

    public int getStatus(String machine_id, String node_id) {
        IPNode node = this.findNode(machine_id, node_id);
        int s = this.getNodeStatus(node);
        return s;
    }

    public int getStatus(String id) {
        return this.getStatus(this.getCurrentMachineId(), id);
    }

    public IPNode findNode(String machine_id, String node_id) {
        IPMachine machine = this.findMachineById(machine_id);
        if (machine == null) {
            System.out.println("\t*** POSSIBLE ERROR: Unable to find machine defined by ID " + machine_id + ")");
            return null;
        }
        return machine.findNode(node_id);
    }

    public IPMachine findMachine(String machine_name) {
        return this.modelPresentation.getUniverse().findMachineByName(machine_name);
    }

    public IPMachine findMachineById(String machine_id) {
        IPUniverse universe = this.modelPresentation.getUniverse();
        return universe.findMachineByGlobalId(machine_id);
    }

    public String getName(String id) {
        IPMachine machine = this.findMachineById(id);
        if (machine == null) {
            return "";
        }
        return machine.getName();
    }

    public void addMachine(IPMachine mac) {
        if (this.machineList.containsKey(mac.getIDString())) {
            return;
        }
        IPNode[] pNodes = mac.getSortedNodes();
        int total_element = pNodes.length;
        if (total_element > 0) {
            ElementHandler elementHandler = new ElementHandler();
            IElementSet set = elementHandler.getSetRoot();
            int i = 0;
            while (i < total_element) {
                set.add(new Element(set, pNodes[i].getIDString(), pNodes[i].getName()));
                ++i;
            }
            elementHandler.add(set);
            this.machineList.put(mac.getIDString(), elementHandler);
        }
    }

    public String initial() {
        this.clear();
        IPMachine[] macs = this.getMachines();
        if (macs.length > 0) {
            this.cur_machine_id = macs[0].getIDString();
            int j = 0;
            while (j < macs.length) {
                this.addMachine(macs[j]);
                ++j;
            }
            this.setCurrentSetId("Root");
        }
        return this.cur_machine_id;
    }

    public boolean isCurrentSetContainNode(String mid, String nodeID) {
        if (!this.getCurrentMachineId().equals(mid)) {
            return false;
        }
        IElementHandler elementHandler = this.getElementHandler(this.getCurrentMachineId());
        if (elementHandler == null) {
            return false;
        }
        IElementSet set = elementHandler.getSet(this.getCurrentSetId());
        if (set == null) {
            return false;
        }
        return set.contains(nodeID);
    }
}

