/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.ui.model.Element;
import org.eclipse.ptp.ui.model.IContainer;
import org.eclipse.ptp.ui.model.IElement;

public abstract class Container
extends Element
implements IContainer {
    protected Map dataMap = new HashMap();
    protected Map elementMap = new HashMap();
    protected IElement[] sortedArray = new IElement[0];
    protected int store_element_type = 2;

    public Container(IElement parent, String id, String name, int cur_type) {
        super(parent, id, name);
        this.store_element_type = cur_type;
    }

    public void setData(String key, Object data) {
        this.dataMap.put(key, data);
    }

    public Object getData(String key) {
        return this.dataMap.get(key);
    }

    public IElement getParent() {
        return this.parent;
    }

    public boolean contains(String id) {
        return this.elementMap.containsKey(id);
    }

    public void add(IElement element) {
        if (!this.contains(element.getID())) {
            this.elementMap.put(element.getID(), element);
        }
    }

    public void remove(IElement element) {
        this.remove(element.getID());
    }

    public void remove(String id) {
        if (this.contains(id)) {
            this.elementMap.remove(id);
        }
    }

    public abstract IElement[] get();

    public IElement[] getSorted() {
        if (this.sortedArray.length != this.size()) {
            this.refresh(this.store_element_type);
        }
        return this.sortedArray;
    }

    public IElement get(String id) {
        return (IElement)this.elementMap.get(id);
    }

    public IElement get(int index) {
        return this.getSorted()[index];
    }

    public String getElementID(int index) {
        return this.get(index).getID();
    }

    public void clearAll() {
        this.elementMap.clear();
        this.sortedArray = new IContainer[0];
    }

    public int size() {
        return this.elementMap.size();
    }

    public void refresh(int type) {
        IElement[] sortingElements = this.get();
        this.sort(sortingElements, type);
        this.sortedArray = sortingElements;
    }

    /*
     * Unable to fully structure code
     */
    private void quickSortNum(IElement[] element, int low, int high) {
        block5: {
            lo = low;
            hi = high;
            if (high <= low) break block5;
            mid = Integer.parseInt(element[(low + high) / 2].getID());
            ** GOTO lbl16
            {
                ++lo;
                do {
                    if (lo < high && Integer.parseInt(element[lo].getID()) < mid) continue block0;
                    while (hi > low && Integer.parseInt(element[hi].getID()) > mid) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    this.swap(element, lo, hi);
                    ++lo;
                    --hi;
lbl16:
                    // 3 sources

                } while (lo <= hi);
            }
            if (low < hi) {
                this.quickSortNum(element, low, hi);
            }
            if (lo < high) {
                this.quickSortNum(element, lo, high);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void quickSortText(IElement[] element, int low, int high) {
        block5: {
            lo = low;
            hi = high;
            mid = "";
            if (high <= low) break block5;
            mid = element[(low + high) / 2].getID();
            ** GOTO lbl17
            {
                ++lo;
                do {
                    if (lo < high && element[lo].getID().compareTo(mid) < 0) continue block0;
                    while (hi > low && element[hi].getID().compareTo(mid) > 0) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    this.swap(element, lo, hi);
                    ++lo;
                    --hi;
lbl17:
                    // 3 sources

                } while (lo <= hi);
            }
            if (low < hi) {
                this.quickSortText(element, low, hi);
            }
            if (lo < high) {
                this.quickSortText(element, lo, high);
            }
        }
    }

    private void swap(IElement[] element, int i, int j) {
        IElement tempElement = element[i];
        element[i] = element[j];
        element[j] = tempElement;
    }

    protected void sort(IElement[] element, int type) {
        if (type == 1) {
            this.quickSortText(element, 0, element.length - 1);
        } else {
            this.quickSortNum(element, 0, element.length - 1);
        }
    }
}

