/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ptp.ui.model.Container;
import org.eclipse.ptp.ui.model.ElementSet;
import org.eclipse.ptp.ui.model.IContainer;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;

public class ElementHandler
extends Container
implements IElementHandler {
    private final String REGISTERED_KEY = "registeredset";

    public ElementHandler() {
        super(null, "Root", "Root", 1);
        this.setData("registeredset", new ArrayList());
        this.add(new ElementSet(this, "Root", "Root"));
    }

    public IElementSet getSetRoot() {
        if (this.size() == 0) {
            this.add(new ElementSet(this, "Root", "Root"));
        }
        return (IElementSet)this.get("Root");
    }

    public void clearAll() {
        Iterator i = this.elementMap.values().iterator();
        while (i.hasNext()) {
            ((IContainer)i.next()).clearAll();
        }
        super.clearAll();
    }

    public IElement[] get() {
        return this.getSets();
    }

    public IElementSet[] getSortedSets() {
        return (IElementSet[])this.getSorted();
    }

    public IElementSet[] getSets() {
        return this.elementMap.values().toArray(new IElementSet[0]);
    }

    public IElementSet getSet(String id) {
        return (IElementSet)this.get(id);
    }

    public IElementSet getSet(int index) {
        return (IElementSet)this.get(index);
    }

    public IElementSet[] getSetsWithElement(String id) {
        ArrayList<IElementSet> aList = new ArrayList<IElementSet>();
        IElementSet[] sets = this.getSortedSets();
        int i = 0;
        while (i < sets.length) {
            if (sets[i].contains(id)) {
                aList.add(sets[i]);
            }
            ++i;
        }
        return aList.toArray(new IElementSet[0]);
    }

    public boolean containsRegisterElement(IElement element) {
        List setList = this.getRegisteredSetList();
        return setList.contains(element);
    }

    public void addRegisterElement(IElement element) {
        List setList = this.getRegisteredSetList();
        if (!setList.contains(element)) {
            setList.add(element);
        }
    }

    public void removeRegisterElement(IElement element) {
        List setList = this.getRegisteredSetList();
        if (setList.contains(element)) {
            setList.remove(element);
        }
    }

    public IElement[] getRegisteredElements() {
        List setList = this.getRegisteredSetList();
        return setList.toArray(new IElement[0]);
    }

    public void removeAllRegisterElements() {
        List setList = this.getRegisteredSetList();
        setList.clear();
    }

    public int totalRegisterElements() {
        List setList = this.getRegisteredSetList();
        return setList.size();
    }

    private List getRegisteredSetList() {
        return (List)this.getData("registeredset");
    }
}

