/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.ui.model.Container;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;

public class ElementSet
extends Container
implements IElementSet {
    private final String MATCHSET_KEY = "matchset";

    public ElementSet(IElement parent, String id, String name) {
        super(parent, id, name, 2);
        this.setData("matchset", new ArrayList());
    }

    public IElementHandler getElementHandler() {
        return (IElementHandler)this.parent;
    }

    public boolean isRootSet() {
        return this.id.equals("Root");
    }

    public IElement[] get() {
        return this.getElements();
    }

    public IElement[] getSortedElements() {
        return this.getSorted();
    }

    public IElement[] getElements() {
        return this.elementMap.values().toArray(new IElement[this.elementMap.size()]);
    }

    public IElement getElement(String id) {
        return this.get(id);
    }

    public IElement getElement(int index) {
        return this.get(index);
    }

    public void addMatchSet(String setId) {
        List setList = this.getMatchSetList();
        if (!setList.contains(setId)) {
            setList.add(setId);
        }
    }

    public void removeMatchSet(String setId) {
        List setList = this.getMatchSetList();
        if (setList.contains(setId)) {
            setList.remove(setId);
        }
    }

    public String[] getMatchSets() {
        List setList = this.getMatchSetList();
        return setList.toArray(new String[setList.size()]);
    }

    public boolean containOtherSets() {
        List setList = this.getMatchSetList();
        return setList.size() > 0;
    }

    public boolean isContainSets(String set_id) {
        List setList = this.getMatchSetList();
        return setList.contains(set_id);
    }

    private List getMatchSetList() {
        return (List)this.getData("matchset");
    }
}

