/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractPerferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected IWorkbench fWorkbench;

    public void init(IWorkbench workbench) {
        this.fWorkbench = workbench;
    }

    protected IWorkbench getWorkbench() {
        return this.fWorkbench;
    }

    protected Composite createGroupComposite(Composite parent, int numColumns, boolean makeBalance, String labelText) {
        Group comp = new Group(parent, 16);
        GridLayout layout = new GridLayout(numColumns, makeBalance);
        comp.setLayout((Layout)layout);
        layout.marginLeft = 2;
        layout.marginTop = 2;
        layout.marginRight = 2;
        layout.marginBottom = 2;
        GridData gd = new GridData(768);
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 4;
        comp.setLayoutData((Object)gd);
        comp.setText(labelText);
        comp.setFont(parent.getFont());
        return comp;
    }

    protected Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(numColumns, false));
        composite.setLayoutData((Object)new GridData(768));
        return composite;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        button.setLayoutData((Object)new GridData(768));
        return button;
    }

    protected Combo createCombo(Composite parent, String label, String[] data, String selectedData) {
        this.createLabel(parent, label, -1, -1, 16384);
        Combo combo = new Combo(parent, 2060);
        combo.setLayoutData((Object)new GridData(768));
        combo.setItems(data);
        int selectedIndex = combo.indexOf(selectedData);
        combo.select(selectedIndex < 0 ? 0 : selectedIndex);
        return combo;
    }

    protected Label createLabel(Composite parent, String text, int widthHint, int heightHint, int style) {
        Label label = new Label(parent, style);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.widthHint = widthHint;
        gd.heightHint = heightHint;
        label.setLayoutData((Object)gd);
        return label;
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    protected IWorkbenchPage[] getPages() {
        final ArrayList pages = new ArrayList();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (AbstractPerferencePage.this.fWorkbench != null) {
                    IWorkbenchWindow[] windows = AbstractPerferencePage.this.fWorkbench.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        pages.add(windows[i].getActivePage());
                        ++i;
                    }
                }
            }
        });
        return pages.toArray(new IWorkbenchPage[0]);
    }

    protected abstract void storeValues();

    protected abstract void setValues();
}

