/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.core.ControlSystemChoices;
import org.eclipse.ptp.core.MonitoringSystemChoices;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.internal.core.CoreMessages;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.utils.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PTPPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String EMPTY_STRING = "";
    protected Text outputDirText = null;
    protected Button browseButton = null;
    protected IntegerFieldEditor storeLineField = null;
    protected Combo comboCS = null;
    protected Combo comboMS = null;
    private String outputDIR = "";
    private String defaultOutputDIR = "/tmp";
    private int storeLine = 100;
    private int MSChoiceID = -1;
    private int CSChoiceID = -1;
    private int lastMSChoiceID = -1;
    private int lastCSChoiceID = -1;
    protected Button develModeButton = null;
    protected WidgetListener listener = new WidgetListener();

    public PTPPreferencesPage() {
        this.setPreferenceStore(PTPCorePlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.createGridLayout(1, true, 0, 0));
        composite.setLayoutData((Object)this.spanGridData(768, 2));
        this.createChooseRSContents(composite);
        this.createOutputContents(composite);
        this.develModeButton = this.createCheckButton(composite, CoreMessages.getResourceString((String)"PTPPreferencesPage.devel_mode"));
        this.loadSaved();
        this.defaultSetting();
        return composite;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    private void createOutputContents(Composite parent) {
        Group aGroup = new Group(parent, 16);
        aGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        aGroup.setLayoutData((Object)this.spanGridData(768, 2));
        aGroup.setText(CoreMessages.getResourceString((String)"PTPPreferencesPage.group_output"));
        Composite outputComposite = new Composite((Composite)aGroup, 0);
        outputComposite.setLayout((Layout)this.createGridLayout(3, false, 0, 0));
        outputComposite.setLayoutData((Object)this.spanGridData(768, 5));
        new Label(outputComposite, 0).setText(CoreMessages.getResourceString((String)"PTPPreferencesPage.output_text"));
        this.outputDirText = new Text(outputComposite, 2052);
        this.outputDirText.setLayoutData((Object)new GridData(768));
        this.outputDirText.addModifyListener((ModifyListener)this.listener);
        this.browseButton = SWTUtil.createPushButton(outputComposite, CoreMessages.getResourceString((String)"PTPPreferencesPage.browseButton"), null);
        this.browseButton.addSelectionListener((SelectionListener)this.listener);
        Composite lineComposite = new Composite((Composite)aGroup, 0);
        lineComposite.setLayout((Layout)new FillLayout());
        lineComposite.setLayoutData((Object)this.spanGridData(768, 5));
        this.storeLineField = new IntegerFieldEditor("STORE_LINE", CoreMessages.getResourceString((String)"PTPPreferencesPage.store_line_text"), lineComposite);
        this.storeLineField.setPropertyChangeListener((IPropertyChangeListener)this.listener);
        this.storeLineField.setEmptyStringAllowed(false);
    }

    private void createChooseRSContents(Composite parent) {
        Group aGroup = new Group(parent, 16);
        aGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        aGroup.setLayoutData((Object)this.spanGridData(768, 2));
        aGroup.setText(CoreMessages.getResourceString((String)"PTPPreferencesPage.group_rs"));
        new Label((Composite)aGroup, 0).setText(CoreMessages.getResourceString((String)"PTPPreferencesPage.group_cs"));
        this.comboCS = new Combo((Composite)aGroup, 8);
        this.comboCS.setItems(ControlSystemChoices.getCSStrings());
        this.comboCS.addSelectionListener((SelectionListener)this.listener);
        new Label((Composite)aGroup, 0).setText(CoreMessages.getResourceString((String)"PTPPreferencesPage.group_ms"));
        this.comboMS = new Combo((Composite)aGroup, 8);
        this.comboMS.setItems(MonitoringSystemChoices.getMSStrings());
        this.comboMS.addSelectionListener((SelectionListener)this.listener);
    }

    protected void defaultSetting() {
        int index = MonitoringSystemChoices.getMSArrayIndexByID((int)this.MSChoiceID);
        if (index < 0) {
            index = 0;
        }
        this.comboMS.select(index);
        index = ControlSystemChoices.getCSArrayIndexByID((int)this.CSChoiceID);
        if (index < 0) {
            index = 0;
        }
        this.comboCS.select(index);
        this.outputDirText.setText(this.outputDIR);
        this.storeLineField.setStringValue(String.valueOf(this.storeLine));
    }

    private void loadSaved() {
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        this.outputDIR = preferences.getString("OUTPUT_DIR");
        if (this.outputDIR.equals(EMPTY_STRING)) {
            this.outputDIR = this.defaultOutputDIR;
        }
        if (this.outputDIR != null) {
            this.outputDirText.setText(this.outputDIR);
        }
        this.storeLine = preferences.getInt("STORE_LINE");
        this.storeLineField.setStringValue(String.valueOf(this.storeLine));
        this.MSChoiceID = preferences.getInt("MONITORING_SYSTEM_SELECTION");
        this.comboMS.select(MonitoringSystemChoices.getMSArrayIndexByID((int)this.MSChoiceID));
        this.lastMSChoiceID = this.MSChoiceID;
        this.CSChoiceID = preferences.getInt("CONTROL_SYSTEM_SELECTION");
        this.comboCS.select(ControlSystemChoices.getCSArrayIndexByID((int)this.CSChoiceID));
        this.lastCSChoiceID = this.CSChoiceID;
        this.develModeButton.setSelection(preferences.getBoolean("DEVELOPER_MODE"));
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
    }

    public void performDefaults() {
        this.defaultSetting();
        this.updateApplyButton();
    }

    private void store() {
        this.MSChoiceID = MonitoringSystemChoices.getMSIDByIndex((int)this.comboMS.getSelectionIndex());
        this.CSChoiceID = ControlSystemChoices.getCSIDByIndex((int)this.comboCS.getSelectionIndex());
        this.outputDIR = this.outputDirText.getText();
        this.storeLine = this.storeLineField.getIntValue();
    }

    public boolean performOk() {
        this.store();
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        preferences.setValue("MONITORING_SYSTEM_SELECTION", this.MSChoiceID);
        preferences.setValue("CONTROL_SYSTEM_SELECTION", this.CSChoiceID);
        preferences.setValue("OUTPUT_DIR", this.outputDIR);
        preferences.setValue("STORE_LINE", this.storeLine);
        preferences.setValue("DEVELOPER_MODE", this.develModeButton.getSelection());
        PTPCorePlugin.getDefault().savePluginPreferences();
        boolean force = this.lastCSChoiceID != this.CSChoiceID || this.lastMSChoiceID != this.MSChoiceID;
        PTPUIPlugin.getDefault().refreshRuntimeSystem(true, force);
        File outputDirPath = new File(this.outputDIR);
        if (!outputDirPath.exists()) {
            outputDirPath.mkdir();
        }
        this.lastCSChoiceID = this.CSChoiceID;
        this.lastMSChoiceID = this.MSChoiceID;
        return true;
    }

    protected void handleOutputDirectoryBrowseButtonSelected() {
        String selectedDirPath;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(CoreMessages.getResourceString((String)"PTPPreferencesPage.Select_Output_Directory"));
        String currectDirPath = this.getFieldContent(this.outputDirText.getText());
        if (currectDirPath != null && (path = new File(currectDirPath)).exists()) {
            dialog.setFilterPath(currectDirPath);
        }
        if ((selectedDirPath = dialog.open()) != null) {
            this.outputDirText.setText(selectedDirPath);
        }
    }

    protected boolean isValidMSSetting() {
        int MS = this.comboMS.getSelectionIndex();
        if (MS < 0) {
            this.setErrorMessage("Select a monitoring system.");
            this.setValid(false);
            return false;
        }
        int MSID = MonitoringSystemChoices.getMSIDByIndex((int)MS);
        switch (MSID) {
            case 100: 
            case 101: 
            case 105: {
                break;
            }
            default: {
                this.setErrorMessage("Sorry, that monitoring system choice is not yet implemented.");
                this.setValid(false);
                return false;
            }
        }
        return true;
    }

    protected boolean isValidCSSetting() {
        int CS = this.comboCS.getSelectionIndex();
        if (CS < 0) {
            this.setErrorMessage("Select a control system.");
            this.setValid(false);
            return false;
        }
        int CSID = ControlSystemChoices.getCSIDByIndex((int)CS);
        switch (CSID) {
            case 100: 
            case 101: 
            case 105: {
                break;
            }
            default: {
                this.setErrorMessage("Sorry, that control system choice is not yet implemented.");
                this.setValid(false);
                return false;
            }
        }
        return true;
    }

    protected boolean isValidRSSetting() {
        int CS = this.comboCS.getSelectionIndex();
        int MS = this.comboMS.getSelectionIndex();
        int CSID = ControlSystemChoices.getCSIDByIndex((int)CS);
        int MSID = MonitoringSystemChoices.getMSIDByIndex((int)MS);
        if (CSID == 100 && MSID == 100) {
            return true;
        }
        if (CSID == 101 && MSID == 101) {
            return true;
        }
        if (CSID == 105 && MSID == 105) {
            return true;
        }
        this.setErrorMessage("Sorry, that combination of control and monitoring systems it not valid.");
        this.setValid(false);
        return false;
    }

    protected boolean isValidOutputSetting() {
        File parent;
        String name = this.getFieldContent(this.outputDirText.getText());
        if (name == null) {
            this.setErrorMessage(CoreMessages.getResourceString((String)"PTPPreferencesPage.Incorrect_Output_directory"));
            this.setValid(false);
            return false;
        }
        File path = new File(name);
        if (!(path.exists() || (parent = path.getParentFile()) != null && parent.exists())) {
            this.setErrorMessage(CoreMessages.getResourceString((String)"PTPPreferencesPage.Incorrect_Output_directory"));
            this.setValid(false);
            return false;
        }
        if (!this.storeLineField.isValid()) {
            this.setErrorMessage(this.storeLineField.getErrorMessage());
            this.setValid(false);
            return false;
        }
        return true;
    }

    protected void updatePreferencePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.isValidCSSetting()) {
            return;
        }
        if (!this.isValidMSSetting()) {
            return;
        }
        if (!this.isValidRSSetting()) {
            return;
        }
        if (!this.isValidOutputSetting()) {
            return;
        }
        this.setValid(true);
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == PTPPreferencesPage.this.browseButton) {
                PTPPreferencesPage.this.handleOutputDirectoryBrowseButtonSelected();
            } else {
                PTPPreferencesPage.this.updatePreferencePage();
            }
        }

        public void modifyText(ModifyEvent evt) {
            PTPPreferencesPage.this.updatePreferencePage();
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                PTPPreferencesPage.this.updatePreferencePage();
            }
        }
    }
}

