/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.internal.ui.actions.ChangeSetAction;
import org.eclipse.ptp.internal.ui.actions.CreateSetAction;
import org.eclipse.ptp.internal.ui.actions.DeleteSetAction;
import org.eclipse.ptp.internal.ui.actions.DisplayRulerAction;
import org.eclipse.ptp.internal.ui.actions.RemoveElementAction;
import org.eclipse.ptp.internal.ui.actions.ZoomInAction;
import org.eclipse.ptp.internal.ui.actions.ZoomOutAction;
import org.eclipse.ptp.ui.IManager;
import org.eclipse.ptp.ui.IPTPUIConstants;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.actions.ParallelAction;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.views.AbstractParallelElementView;
import org.eclipse.ptp.ui.views.ProcessEditorInput;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;

public abstract class AbstractParallelSetView
extends AbstractParallelElementView {
    protected List clipboard = new ArrayList();
    protected String cur_selected_element_id = "";
    protected ParallelAction createSetAction = null;
    protected ParallelAction deleteSetAction = null;
    protected ParallelAction deleteProcessAction = null;
    protected ParallelAction changeSetAction = null;
    protected ParallelAction zoomInAction = null;
    protected ParallelAction zoomOutAction = null;
    protected int zoom_depth = 0;
    protected Zoom zoom = new Zoom();
    protected int last_action = -1;
    protected IElementSet last_element_set = null;

    public AbstractParallelSetView(IManager manager) {
        super(manager);
    }

    public void dispose() {
        this.clipboard.clear();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IToolBarManager toolBarMgr = this.getViewSite().getActionBars().getToolBarManager();
        this.createToolBarActionGroup(toolBarMgr);
        this.createToolBarActions(toolBarMgr);
        IMenuManager menuMgr = this.getViewSite().getActionBars().getMenuManager();
        this.createMenuActions(menuMgr);
        this.createContextMenu();
        this.initialView();
        PTPUIPlugin.getDefault().refreshRuntimeSystem(true, false);
    }

    protected void createToolBarActionGroup(IToolBarManager toolBarMgr) {
        toolBarMgr.add((IContributionItem)new Separator("zoomgroup"));
        toolBarMgr.add((IContributionItem)new Separator("navigatorgroup"));
        toolBarMgr.add((IContributionItem)new Separator("actiongroup"));
        toolBarMgr.add((IContributionItem)new Separator("emptygroup"));
        toolBarMgr.add((IContributionItem)new Separator("setgroup"));
        toolBarMgr.add((IContributionItem)new Separator("changesetgroup"));
    }

    protected void buildInToolBarActions(IToolBarManager toolBarMgr) {
        this.zoomOutAction = new ZoomOutAction(this);
        this.zoomInAction = new ZoomInAction(this);
        this.createSetAction = new CreateSetAction(this);
        this.deleteSetAction = new DeleteSetAction(this);
        this.deleteProcessAction = new RemoveElementAction(this);
        this.changeSetAction = new ChangeSetAction(this);
        toolBarMgr.appendToGroup("zoomgroup", (IAction)this.zoomOutAction);
        toolBarMgr.appendToGroup("zoomgroup", (IAction)this.zoomInAction);
        toolBarMgr.appendToGroup("setgroup", (IAction)this.createSetAction);
        toolBarMgr.appendToGroup("setgroup", (IAction)this.deleteSetAction);
        toolBarMgr.appendToGroup("setgroup", (IAction)this.deleteProcessAction);
        toolBarMgr.appendToGroup("changesetgroup", (IAction)this.changeSetAction);
    }

    protected void createToolBarActions(IToolBarManager toolBarMgr) {
        this.buildInToolBarActions(toolBarMgr);
    }

    protected void createMenuActions(IMenuManager menuMgr) {
    }

    protected void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#popupmenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractParallelSetView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.canvas);
        this.canvas.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.canvas);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("actiongroup"));
        manager.add((IContributionItem)new Separator("emptygroup"));
        manager.add((IContributionItem)new Separator("zoomgroup"));
        manager.add((IAction)this.zoomOutAction);
        manager.add((IAction)this.zoomInAction);
        manager.add((IContributionItem)new Separator("changesetgroup"));
        manager.add((IAction)this.changeSetAction);
        manager.add((IContributionItem)new Separator("viewgroup"));
        manager.add((IAction)new DisplayRulerAction(this));
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void update() {
        this.updateTitle();
    }

    public void updateTitle() {
        if (this.cur_element_set != null) {
            this.changeTitle(this.manager.getName(this.getCurrentID()), this.cur_element_set.getID(), this.cur_set_size);
        } else {
            this.changeTitle(" ");
        }
    }

    public void updateAction() {
        boolean deleteActionEnable = this.manager.getCurrentSetId().length() == 0 || this.manager.getCurrentSetId().equals("Root");
        this.deleteSetAction.setEnabled(!deleteActionEnable);
        this.deleteProcessAction.setEnabled(!deleteActionEnable);
        this.createSetAction.setEnabled(this.cur_set_size > 0);
        IElementHandler elementHandler = this.getCurrentElementHandler();
        this.changeSetAction.setEnabled(elementHandler != null && elementHandler.size() != 0);
        this.zoomInAction.setEnabled(this.cur_set_size > 0 && this.zoom_depth > 0);
        this.zoomOutAction.setEnabled(this.cur_set_size > 0 && this.zoom_depth < 3);
    }

    protected void openProcessViewer(final IPProcess element) {
        if (element == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    PTPUIPlugin.getActivePage().openEditor((IEditorInput)new ProcessEditorInput(element), IPTPUIConstants.VIEW_PARALLELProcess);
                }
                catch (PartInitException e) {
                    PTPUIPlugin.log(e);
                }
            }
        });
    }

    public void handleAction(int type, int[] indexes) {
        if (this.cur_element_set == null) {
            return;
        }
        IElement[] elements = this.canvas.getElements(indexes);
        switch (type) {
            case 1: {
                if (elements.length <= 0) break;
                this.clipboard.clear();
                this.clipboard.add(elements);
                break;
            }
            case 2: {
                if (elements.length <= 0 || this.cur_element_set.isRootSet()) break;
                this.clipboard.clear();
                this.clipboard.add(elements);
                this.last_action = type;
                this.last_element_set = this.cur_element_set;
                break;
            }
            case 3: {
                if (this.clipboard.size() <= 0) break;
                IElement[] clipElements = (IElement[])this.clipboard.get(0);
                if (this.last_action == 2 && this.last_element_set != null && !this.last_element_set.getID().equals(this.cur_element_set.getID())) {
                    if (this.last_element_set.size() == clipElements.length) {
                        this.manager.removeSet(this.last_element_set.getID(), this.last_element_set.getElementHandler());
                    } else {
                        this.manager.removeFromSet(clipElements, this.last_element_set.getID(), this.last_element_set.getElementHandler());
                    }
                }
                if (this.cur_element_set.isRootSet()) {
                    this.createSetAction.run(clipElements);
                } else {
                    this.manager.addToSet(clipElements, this.cur_element_set.getID(), this.cur_element_set.getElementHandler());
                    this.selectSet(this.cur_element_set.getElementHandler().getSet(this.cur_element_set.getID()));
                    this.update();
                    this.refresh(false);
                }
                this.last_action = -1;
                this.last_element_set = null;
                break;
            }
            case 4: {
                if (elements.length <= 0 || this.cur_element_set.isRootSet()) break;
                this.deleteProcessAction.run(elements);
            }
        }
    }

    public void zoomOut() {
        if (this.zoom_depth < 3) {
            ++this.zoom_depth;
            this.updateAction();
            this.update();
            if (!this.canvas.isDisposed()) {
                this.canvas.setIconSize(this.zoom.scaled(16, this.zoom_depth), this.zoom.scaled(16, this.zoom_depth));
                this.canvas.setIconSpace(4 - this.zoom_depth, 4);
                this.canvas.setFontSizeSmaller();
                this.canvas.resetCanvas();
            }
        }
    }

    public void zoomIn() {
        if (this.zoom_depth > 0) {
            --this.zoom_depth;
            this.updateAction();
            this.update();
            if (!this.canvas.isDisposed()) {
                this.canvas.setIconSize(this.zoom.scaled(16, this.zoom_depth), this.zoom.scaled(16, this.zoom_depth));
                this.canvas.setIconSpace(4 - this.zoom_depth, 4);
                this.canvas.setFontSizeBigger();
                this.canvas.resetCanvas();
            }
        }
    }

    public Image getStatusIcon(Object obj, boolean isSelected) {
        Image img = super.getStatusIcon(obj, isSelected);
        if (img != null) {
            return this.zoom.getImage(img, this.zoom_depth);
        }
        return null;
    }

    class Zoom {
        protected static final int max_depth = 3;
        protected Map zoomImageMap = new HashMap();

        Zoom() {
        }

        public void cleanup() {
            this.zoomImageMap.clear();
        }

        public Image getImage(Image image, int depth) {
            if (depth == 0) {
                return image;
            }
            Image[] images = (Image[])this.zoomImageMap.get(image);
            if (images == null) {
                images = new Image[3];
                this.zoomImageMap.put(image, images);
            }
            return this.getZoomImage(images, image, depth);
        }

        public Image getZoomImage(Image[] images, Image orgImg, int depth) {
            if (images[depth - 1] == null) {
                images[depth - 1] = this.scaledImage(orgImg, depth);
            }
            return images[depth - 1];
        }

        public double getScale(int depth) {
            double fix_factor = 0.2;
            return 1.0 - fix_factor * (double)depth;
        }

        public int scaled(int measure, int depth) {
            return (int)((double)measure * this.getScale(depth));
        }

        public Image scaledImage(Image image, int depth) {
            return new Image(image.getDevice(), image.getImageData().scaledTo(this.scaled(16, depth), this.scaled(16, depth)));
        }
    }
}

