/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.views;

import java.util.ArrayList;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.views.AbstractParallelElementView;
import org.eclipse.ptp.ui.views.IconCanvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class ElementIconCanvas
extends IconCanvas
implements ISelectionProvider {
    private IElementSet cur_element_set = null;
    private ListenerList listeners = new ListenerList();
    private ISelection selection = null;

    public ElementIconCanvas(AbstractParallelElementView view, Composite parent, int style) {
        super(parent, style);
        IPreferenceStore store = PTPUIPlugin.getDefault().getPreferenceStore();
        this.setIconSpace(store.getInt("icon_spacing_x"), store.getInt("icon_spacing_y"));
        this.setIconSize(store.getInt("icon_width"), store.getInt("icon_height"));
        this.setTooltip(store.getBoolean("tt_show_all_time"), store.getLong("tt_timeout"), store.getBoolean("tt_iswap"));
    }

    public void dispose() {
        this.listeners.clear();
        this.selection = null;
        this.cur_element_set = null;
        super.dispose();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setElementSet(IElementSet e_set) {
        this.cur_element_set = e_set;
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                ElementIconCanvas.this.setTotal(ElementIconCanvas.this.cur_element_set == null ? 0 : ElementIconCanvas.this.cur_element_set.size());
            }
        });
    }

    public IElementSet getCurrentElementSet() {
        return this.cur_element_set;
    }

    public IElement getElement(int index) {
        if (this.cur_element_set == null) {
            return null;
        }
        return this.cur_element_set.getSortedElements()[index];
    }

    public IElement[] getElements(int[] indexes) {
        if (this.cur_element_set == null) {
            return new IElement[0];
        }
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        int i = 0;
        while (i < indexes.length) {
            selectedElements.add(this.cur_element_set.get(indexes[i]));
            ++i;
        }
        return selectedElements.toArray(new IElement[selectedElements.size()]);
    }

    public IElement[] getSelectedElements() {
        return this.getElements(this.getSelectedIndexes());
    }

    public ISelection getSelection() {
        if (this.selection == null) {
            return StructuredSelection.EMPTY;
        }
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        final SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)array[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(e);
                }
            });
            ++i;
        }
    }

    public void setCurrentSelection(boolean sendEvent) {
        this.selection = new StructuredSelection((Object[])this.getSelectedElements());
        if (sendEvent) {
            this.setSelection(this.selection);
        }
    }

    protected void handleMouseUp(Event event) {
        super.handleMouseUp(event);
        this.setSelection((ISelection)new StructuredSelection((Object[])this.getSelectedElements()));
    }

    protected void doSelectionAll() {
        super.doSelectionAll();
        this.setSelection((ISelection)new StructuredSelection((Object[])this.getSelectedElements()));
    }
}

