/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.IProcessListener;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.events.IModelEvent;
import org.eclipse.ptp.core.events.IModelRuntimeNotifierEvent;
import org.eclipse.ptp.core.events.IProcessEvent;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.internal.ui.actions.RemoveAllTerminatedAction;
import org.eclipse.ptp.internal.ui.actions.TerminateAllAction;
import org.eclipse.ptp.ui.IManager;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.actions.ParallelAction;
import org.eclipse.ptp.ui.managers.JobManager;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.views.AbstractParallelSetView;
import org.eclipse.ptp.ui.views.IToolTipProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;

public class ParallelJobView
extends AbstractParallelSetView
implements IProcessListener {
    protected String cur_selected_element_id = "";
    protected Menu jobPopupMenu = null;
    protected SashForm sashForm = null;
    protected TableViewer jobTableViewer = null;
    protected Composite elementViewComposite = null;
    protected ParallelAction terminateAllAction = null;
    public static final String BOTH_VIEW = "0";
    public static final String JOB_VIEW = "1";
    public static final String PRO_VIEW = "2";
    protected String current_view = "0";

    public ParallelJobView(IManager manager) {
        super(manager);
        PTPCorePlugin.getDefault().getModelPresentation().addProcessListener((IProcessListener)this);
    }

    public ParallelJobView() {
        this(PTPUIPlugin.getDefault().getJobManager());
    }

    public void dispose() {
        this.elementViewComposite.dispose();
        PTPCorePlugin.getDefault().getModelPresentation().removeProcessListener((IProcessListener)this);
        super.dispose();
    }

    public String getCurrentView() {
        return this.current_view;
    }

    public void changeView(String view_flag) {
        this.current_view = view_flag;
        if (this.current_view.equals(JOB_VIEW)) {
            this.jobTableViewer.getTable().setVisible(true);
            this.elementViewComposite.setVisible(false);
            int[] nArray = new int[2];
            nArray[0] = 1;
            this.sashForm.setWeights(nArray);
        } else if (this.current_view.equals(PRO_VIEW)) {
            this.jobTableViewer.getTable().setVisible(false);
            this.elementViewComposite.setVisible(true);
            int[] nArray = new int[2];
            nArray[1] = 1;
            this.sashForm.setWeights(nArray);
        } else {
            this.jobTableViewer.getTable().setVisible(true);
            this.elementViewComposite.setVisible(true);
            this.sashForm.setWeights(new int[]{1, 2});
        }
    }

    protected void initialElement() {
        this.changeJob(this.manager.initial());
    }

    protected void initialView() {
        this.initialElement();
    }

    public Image getImage(int index1, int index2) {
        return ParallelImages.procImages[index1][index2];
    }

    protected void createView(Composite parent) {
        parent.setLayout((Layout)new FillLayout(512));
        parent.setLayoutData((Object)new GridData(1808));
        this.sashForm = new SashForm(parent, 256);
        this.sashForm.setLayout((Layout)new FillLayout(512));
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.jobTableViewer = new TableViewer((Composite)this.sashForm, 2052);
        this.jobTableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.jobTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IPJob) {
                    return ((IPJob)element).getName();
                }
                return "";
            }

            public Image getImage(Object element) {
                if (element instanceof IPJob) {
                    IPJob job = (IPJob)element;
                    if (job.isAllStop()) {
                        return ParallelImages.jobImages[2];
                    }
                    if (job.isDebug()) {
                        return ParallelImages.jobImages[1];
                    }
                    return ParallelImages.jobImages[0];
                }
                return null;
            }
        });
        this.jobTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof JobManager) {
                    return ((JobManager)inputElement).getJobs();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.jobTableViewer.setInput((Object)this.manager);
        this.jobTableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ISelection selection = ParallelJobView.this.jobTableViewer.getSelection();
                TableItem item = ParallelJobView.this.jobTableViewer.getTable().getItem(new Point(e.x, e.y));
                if (item == null && !selection.isEmpty()) {
                    ParallelJobView.this.jobTableViewer.getTable().deselectAll();
                    ParallelJobView.this.changeJob((IPJob)null);
                } else if (item != null) {
                    IPJob job = ParallelJobView.this.manager.findJob(item.getText());
                    if (job == null) {
                        ParallelJobView.this.changeJob((IPJob)null);
                    } else if (selection.isEmpty()) {
                        ParallelJobView.this.changeJob(job);
                    } else {
                        String cur_id = ParallelJobView.this.getCurrentID();
                        if (cur_id == null || !cur_id.equals(job.getIDString())) {
                            ParallelJobView.this.changeJob(job);
                        }
                    }
                }
            }
        });
        this.createJobContextMenu();
        this.elementViewComposite = this.createElementView((Composite)this.sashForm);
        this.changeView(this.current_view);
    }

    protected void createJobContextMenu() {
        MenuManager menuMgr = new MenuManager("#jobpopupmenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("actiongroup"));
                manager.add((IContributionItem)new Separator("emptygroup"));
                ParallelJobView.this.fillJobContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.jobTableViewer.getTable());
        this.jobTableViewer.getTable().setMenu(menu);
    }

    protected void fillJobContextMenu(IMenuManager menuManager) {
        RemoveAllTerminatedAction removeAllTerminatedAction = new RemoveAllTerminatedAction(this);
        removeAllTerminatedAction.setEnabled(this.manager.hasStoppedJob());
        menuManager.add((IAction)removeAllTerminatedAction);
    }

    protected void createToolBarActions(IToolBarManager toolBarMgr) {
        this.terminateAllAction = new TerminateAllAction(this);
        toolBarMgr.appendToGroup("actiongroup", (IAction)this.terminateAllAction);
        super.buildInToolBarActions(toolBarMgr);
    }

    public void doubleClick(IElement element) {
        this.openProcessViewer(((JobManager)this.manager).findProcess(this.getCurrentID(), element.getIDNum()));
    }

    protected Object convertElementObject(IElement element) {
        if (element == null) {
            return null;
        }
        return ((JobManager)this.manager).findProcess(this.getCurrentID(), element.getIDNum());
    }

    public String getRulerIndex(Object obj, int index) {
        if (obj instanceof IElement) {
            return ((IElement)obj).getID();
        }
        return super.getRulerIndex(obj, index);
    }

    public String[] getToolTipText(Object obj) {
        IElementHandler setManager = this.getCurrentElementHandler();
        if (obj == null || !(obj instanceof IPProcess) || setManager == null || this.cur_element_set == null) {
            return IToolTipProvider.NO_TOOLTIP;
        }
        IPProcess proc = (IPProcess)obj;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Task ID: " + proc.getTaskId());
        buffer.append("\n");
        buffer.append("Process ID: " + proc.getPid());
        IElementSet[] sets = setManager.getSetsWithElement(proc.getIDString());
        if (sets.length > 1) {
            buffer.append("\nSet: ");
        }
        int i = 1;
        while (i < sets.length) {
            buffer.append(sets[i].getID());
            if (i < sets.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return new String[]{buffer.toString()};
    }

    public String getCurrentID() {
        return ((JobManager)this.manager).getCurrentJobId();
    }

    protected void selectJob(String job_id) {
        ((JobManager)this.manager).setCurrentJobId(job_id);
        this.updateJob();
    }

    public IPJob getCheckedJob() {
        String job_id = this.getCurrentID();
        if (!this.manager.isNoJob(job_id)) {
            return this.manager.findJobById(job_id);
        }
        return null;
    }

    public void changeJob(final String job_id) {
        if (!this.elementViewComposite.isDisposed()) {
            this.getDisplay().syncExec(new Runnable(){

                public void run() {
                    IPJob job = ParallelJobView.this.manager.findJobById(job_id);
                    ParallelJobView.this.changeJob(job);
                    ParallelJobView.this.jobTableViewer.refresh(true);
                    ParallelJobView.this.jobTableViewer.setSelection((ISelection)(job == null ? new StructuredSelection() : new StructuredSelection((Object)job)), true);
                }
            });
        }
    }

    protected void changeJob(IPJob job) {
        this.selectJob(job == null ? "" : job.getIDString());
        this.updateAction();
        this.update();
    }

    public void updateJob() {
        IElementHandler setManager = this.getCurrentElementHandler();
        this.selectSet(setManager == null ? null : setManager.getSetRoot());
    }

    public void updateAction() {
        super.updateAction();
        if (this.terminateAllAction != null) {
            ISelection selection = this.jobTableViewer.getSelection();
            if (selection.isEmpty()) {
                this.terminateAllAction.setEnabled(false);
            } else {
                IPJob job = (IPJob)((IStructuredSelection)selection).getFirstElement();
                this.terminateAllAction.setEnabled(!job.isDebug() && !job.isAllStop());
            }
        }
    }

    public void repaint(boolean all) {
        if (all && !this.jobTableViewer.getTable().isDisposed()) {
            this.jobTableViewer.refresh(true);
        }
        this.update();
    }

    public void processEvent(IProcessEvent event) {
        IPProcess process = event.getProcess();
        if (((JobManager)this.manager).isCurrentSetContainProcess(this.getCurrentID(), process.getIDString()) && event.getType() != 3) {
            this.refresh(false);
        }
    }

    public void setFocus() {
        super.setFocus();
        IPJob job = this.getCheckedJob();
        if (job == null) {
            this.changeJob((String)null);
        }
    }

    public void modelEvent(IModelEvent event) {
        if (event instanceof IModelRuntimeNotifierEvent) {
            IModelRuntimeNotifierEvent runtimeEvent = (IModelRuntimeNotifierEvent)event;
            switch (runtimeEvent.getStatus()) {
                case 0: {
                    this.build();
                    break;
                }
                case 1: {
                    this.build();
                    break;
                }
            }
        }
        super.modelEvent(event);
    }
}

