/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ptp.core.INodeListener;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.events.INodeEvent;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.internal.ui.actions.ChangeMachineAction;
import org.eclipse.ptp.ui.IManager;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.actions.ParallelAction;
import org.eclipse.ptp.ui.listeners.IJobChangedListener;
import org.eclipse.ptp.ui.managers.MachineManager;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.views.AbstractParallelSetView;
import org.eclipse.ptp.ui.views.IToolTipProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ParallelMachineView
extends AbstractParallelSetView
implements INodeListener,
IJobChangedListener {
    protected ParallelAction changeMachineAction = null;
    protected SashForm sashForm = null;
    protected Composite elementViewComposite = null;
    protected Composite infoComposite = null;
    protected Table BLtable = null;
    protected Table BRtable = null;
    public static final String BOTH_VIEW = "0";
    public static final String MACHINE_VIEW = "1";
    public static final String INFO_VIEW = "2";
    protected String current_view = "0";

    public ParallelMachineView(IManager manager) {
        super(manager);
        PTPCorePlugin.getDefault().getModelPresentation().addNodeListener((INodeListener)this);
        manager.addJobChangedListener(this);
    }

    public ParallelMachineView() {
        this(PTPUIPlugin.getDefault().getMachineManager());
    }

    public void dispose() {
        this.manager.removeJobChangedListener(this);
        PTPCorePlugin.getDefault().getModelPresentation().removeNodeListener((INodeListener)this);
        super.dispose();
    }

    public void changeView(String view_flag) {
        this.current_view = view_flag;
        if (this.current_view.equals(MACHINE_VIEW)) {
            this.elementViewComposite.setVisible(true);
            this.infoComposite.setVisible(false);
            int[] nArray = new int[2];
            nArray[0] = 1;
            this.sashForm.setWeights(nArray);
        } else if (this.current_view.equals(INFO_VIEW)) {
            this.elementViewComposite.setVisible(false);
            this.infoComposite.setVisible(true);
            int[] nArray = new int[2];
            nArray[1] = 1;
            this.sashForm.setWeights(nArray);
        } else {
            this.elementViewComposite.setVisible(true);
            this.infoComposite.setVisible(true);
            this.sashForm.setWeights(new int[]{3, 1});
        }
    }

    public Image getImage(int index1, int index2) {
        return ParallelImages.nodeImages[index1][index2];
    }

    protected void initialElement() {
        this.selectMachine(this.manager.initial());
    }

    protected void initialView() {
        this.initialElement();
        if (this.manager.size() > 0) {
            this.refresh(false);
        }
        this.update();
    }

    protected void createView(Composite parent) {
        parent.setLayout((Layout)new FillLayout(512));
        parent.setLayoutData((Object)new GridData(1808));
        this.sashForm = new SashForm(parent, 512);
        this.sashForm.setLayout((Layout)new FillLayout(256));
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.elementViewComposite = this.createElementView((Composite)this.sashForm);
        this.infoComposite = this.createLowerTextRegions((Composite)this.sashForm);
        this.changeView(this.current_view);
    }

    protected Composite createLowerTextRegions(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Group bleft = new Group(composite, 2048);
        bleft.setLayout((Layout)new FillLayout());
        GridData gdtext = new GridData(1808);
        gdtext.grabExcessVerticalSpace = true;
        gdtext.grabExcessHorizontalSpace = true;
        gdtext.horizontalAlignment = 4;
        gdtext.verticalAlignment = 4;
        bleft.setLayoutData((Object)gdtext);
        bleft.setText("Node Info");
        Group bright = new Group(composite, 2048);
        bright.setLayout((Layout)new FillLayout());
        GridData gdlist = new GridData(1808);
        gdlist.grabExcessVerticalSpace = true;
        gdlist.grabExcessHorizontalSpace = true;
        gdlist.horizontalAlignment = 4;
        gdlist.verticalAlignment = 4;
        bright.setLayoutData((Object)gdlist);
        bright.setText("Process Info");
        this.BLtable = new Table((Composite)bleft, 68352);
        this.BLtable.setLayout((Layout)new FillLayout());
        this.BLtable.setHeaderVisible(false);
        this.BLtable.setLinesVisible(true);
        new TableColumn(this.BLtable, 16384).setWidth(80);
        new TableColumn(this.BLtable, 16384).setWidth(200);
        this.BRtable = new Table((Composite)bright, 68352);
        this.BRtable.setLayout((Layout)new FillLayout());
        this.BRtable.setHeaderVisible(false);
        this.BRtable.setLinesVisible(true);
        new TableColumn(this.BRtable, 16384).setWidth(300);
        this.BRtable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                IPNode node = ((MachineManager)ParallelMachineView.this.manager).findNode(ParallelMachineView.this.getCurrentID(), ParallelMachineView.this.cur_selected_element_id);
                if (node != null) {
                    int idx = ParallelMachineView.this.BRtable.getSelectionIndex();
                    IPProcess[] procs = node.getSortedProcesses();
                    if (idx >= 0 && idx < procs.length) {
                        ParallelMachineView.this.openProcessViewer(procs[idx]);
                    }
                }
            }
        });
        return composite;
    }

    protected void createToolBarActions(IToolBarManager toolBarMgr) {
        this.changeMachineAction = new ChangeMachineAction(this);
        toolBarMgr.appendToGroup("navigatorgroup", (IAction)this.changeMachineAction);
        super.buildInToolBarActions(toolBarMgr);
    }

    public void doubleClick(IElement element) {
        boolean isElementRegistered = element.isRegistered();
        this.unregister();
        if (!isElementRegistered) {
            this.register(element);
            this.getCurrentElementHandler().addRegisterElement(element);
        }
        this.updateLowerTextRegions();
    }

    public void register(IElement element) {
        element.setRegistered(true);
    }

    public void unregister() {
        IElementHandler elementHandler = this.getCurrentElementHandler();
        IElementSet rootSet = elementHandler.getSetRoot();
        IElement[] registerElements = elementHandler.getRegisteredElements();
        int i = 0;
        while (i < registerElements.length) {
            IElement pE = rootSet.get(registerElements[i].getID());
            if (pE != null) {
                pE.setRegistered(false);
            }
            ++i;
        }
        elementHandler.removeAllRegisterElements();
    }

    protected Object convertElementObject(IElement element) {
        if (element == null) {
            return null;
        }
        return ((MachineManager)this.manager).findNode(this.getCurrentID(), element.getID());
    }

    public String getRulerIndex(Object obj, int index) {
        Object nodeObj;
        if (obj instanceof IElement && (nodeObj = this.convertElementObject((IElement)obj)) instanceof IPNode) {
            return ((IPNode)nodeObj).getNodeNumber();
        }
        return super.getRulerIndex(obj, index);
    }

    public String[] getToolTipText(Object obj) {
        IElementHandler setManager = this.getCurrentElementHandler();
        if (obj == null || !(obj instanceof IPNode) || setManager == null || this.cur_element_set == null) {
            return IToolTipProvider.NO_TOOLTIP;
        }
        IPNode node = (IPNode)obj;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" " + node.getAttribute("Node Name"));
        IElementSet[] sets = setManager.getSetsWithElement(node.getIDString());
        if (sets.length > 1) {
            buffer.append("\n Set: ");
        }
        int i = 1;
        while (i < sets.length) {
            buffer.append(sets[i].getID());
            if (i < sets.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return new String[]{buffer.toString()};
    }

    public String getCurrentID() {
        return ((MachineManager)this.manager).getCurrentMachineId();
    }

    public void selectMachine(String machine_id) {
        ((MachineManager)this.manager).setCurrentMachineId(machine_id);
        this.updateMachine();
    }

    public void updateMachine() {
        IElementHandler setManager = this.getCurrentElementHandler();
        this.selectSet(setManager == null ? null : setManager.getSetRoot());
    }

    public void updateAction() {
        super.updateAction();
        this.changeMachineAction.setEnabled(((MachineManager)this.manager).getMachines().length > 0);
    }

    public void clearLowerTextRegions() {
        this.BLtable.removeAll();
        this.BRtable.removeAll();
    }

    public void updateLowerTextRegions() {
        this.clearLowerTextRegions();
        this.cur_selected_element_id = "";
        IElementHandler elementHandler = this.getCurrentElementHandler();
        if (elementHandler == null || this.cur_element_set == null || elementHandler.totalRegisterElements() == 0) {
            return;
        }
        String firstRegisteredElementID = elementHandler.getRegisteredElements()[0].getID();
        if (!this.cur_element_set.contains(firstRegisteredElementID)) {
            return;
        }
        this.cur_selected_element_id = firstRegisteredElementID;
        IPNode node = ((MachineManager)this.manager).findNode(this.getCurrentID(), this.cur_selected_element_id);
        if (node == null) {
            return;
        }
        String[] keys = node.getAttributeKeys();
        int i = 0;
        while (i < keys.length) {
            new TableItem(this.BLtable, 0).setText(new String[]{keys[i], node.getAttribute(keys[i]).toString()});
            ++i;
        }
        IPProcess[] procs = node.getSortedProcesses();
        if (procs != null) {
            TableItem item = null;
            int i2 = 0;
            while (i2 < procs.length) {
                int proc_state = ((MachineManager)this.manager).getProcStatus(procs[i2].getStatus());
                item = new TableItem(this.BRtable, 0);
                item.setImage(ParallelImages.procImages[proc_state][0]);
                IPJob job = procs[i2].getJob();
                String jobNumber = job == null ? "none" : job.getJobNumber();
                item.setText("Process " + procs[i2].getProcessNumber() + ", Job " + jobNumber);
                ++i2;
            }
        }
    }

    public void repaint(boolean all) {
        this.updateLowerTextRegions();
    }

    public void nodeEvent(INodeEvent event) {
        IPNode node = event.getNode();
        IPMachine machine = node.getMachine();
        String idString = machine == null ? "none" : machine.getIDString();
        if (node != null && ((MachineManager)this.manager).isCurrentSetContainNode(idString, node.getIDString())) {
            this.refresh(false);
        }
    }

    public void jobChangedEvent(int type, String cur_job_id, String pre_job_id) {
        this.refresh(false);
    }
}

