/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.core.IModelListener;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.IProcessListener;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.events.IModelEvent;
import org.eclipse.ptp.core.events.IModelRuntimeNotifierEvent;
import org.eclipse.ptp.core.events.IProcessEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;

public class ParallelProcessView
extends AbstractTextEditor
implements IProcessListener,
IModelListener {
    private final String EXITCODE_TEXT = "Exit code: ";
    private final String SIGNALNAME_TEXT = "Signal name: ";
    private Label rankLabel = null;
    private Label nodeLabel = null;
    private Label jobLabel = null;
    private Label totalLabel = null;
    private Label pidLabel = null;
    private Label statusLabel = null;
    private Label dynamicLabel = null;
    private Text outputText = null;
    private FormToolkit toolkit = null;
    private ScrolledForm myForm = null;

    public ParallelProcessView() {
        this.setDocumentProvider((IDocumentProvider)new StorageDocumentProvider());
        PTPCorePlugin.getDefault().getModelPresentation().addModelListener((IModelListener)this);
        PTPCorePlugin.getDefault().getModelPresentation().addProcessListener((IProcessListener)this);
    }

    public void dispose() {
        PTPCorePlugin.getDefault().getModelPresentation().removeModelListener((IModelListener)this);
        PTPCorePlugin.getDefault().getModelPresentation().removeProcessListener((IProcessListener)this);
        this.myForm.dispose();
        this.toolkit.dispose();
        super.dispose();
    }

    public void setFocus() {
        this.myForm.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setPartName(input.getName());
        this.setInput(input);
    }

    public void close() {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (ParallelProcessView.this.toolkit != null) {
                    ParallelProcessView.this.getSite().getPage().closeEditor((IEditorPart)ParallelProcessView.this, false);
                }
            }
        });
    }

    public IPProcess getProcess() {
        Object obj = this.getEditorInput().getAdapter(IPProcess.class);
        if (obj instanceof IPProcess) {
            return (IPProcess)obj;
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.myForm = this.toolkit.createScrolledForm(parent);
        this.myForm.getBody().setLayout((Layout)this.createGridLayout(1, false, 5, 5));
        this.myForm.getBody().setLayoutData((Object)new GridData(768));
        this.detailsSection();
        this.outputSection();
        this.initialText();
    }

    protected void detailsSection() {
        Section detailsSection = this.toolkit.createSection(this.myForm.getBody(), 256);
        detailsSection.setText("Process details");
        detailsSection.setLayoutData((Object)new GridData(768));
        Composite detailsContainer = this.createClientContainer((Composite)detailsSection, this.toolkit, 3, true, 2, 2);
        this.rankLabel = this.toolkit.createLabel(detailsContainer, null);
        this.rankLabel.setLayoutData((Object)new GridData(768));
        this.nodeLabel = this.toolkit.createLabel(detailsContainer, null);
        this.nodeLabel.setLayoutData((Object)new GridData(768));
        this.totalLabel = this.toolkit.createLabel(detailsContainer, null);
        this.totalLabel.setLayoutData((Object)new GridData(768));
        this.pidLabel = this.toolkit.createLabel(detailsContainer, null);
        this.pidLabel.setLayoutData((Object)new GridData(768));
        this.jobLabel = this.toolkit.createLabel(detailsContainer, null);
        this.jobLabel.setLayoutData((Object)new GridData(768));
        Composite statusContainer = this.createClientContainer(detailsContainer, this.toolkit, 3, true, 0, 0);
        statusContainer.setLayoutData((Object)this.spanGridData(768, 3));
        this.statusLabel = this.toolkit.createLabel(statusContainer, null);
        this.statusLabel.setLayoutData((Object)new GridData(768));
        detailsSection.setClient((Control)detailsContainer);
    }

    protected void outputSection() {
        Section outputSection = this.toolkit.createSection(this.myForm.getBody(), 258);
        outputSection.setText("Program output");
        outputSection.setLayoutData((Object)new GridData(1808));
        outputSection.setExpanded(true);
        Composite ouputContainer = this.createClientContainer((Composite)outputSection, this.toolkit, 1, true, 2, 2);
        this.outputText = this.toolkit.createText(ouputContainer, null, 586);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        this.outputText.setLayoutData((Object)gd);
        outputSection.setClient((Control)ouputContainer);
        this.toolkit.paintBordersFor(ouputContainer);
    }

    protected Composite createClientContainer(Composite parent, FormToolkit toolkit, int columns, boolean isEqual, int mh, int mw) {
        Composite container = toolkit.createComposite(parent);
        container.setLayout((Layout)this.createGridLayout(columns, isEqual, mh, mw));
        return container;
    }

    public void initialText() {
        IPProcess process = this.getProcess();
        this.rankLabel.setText("Rank: N/A");
        this.totalLabel.setText("Total: N/A");
        this.nodeLabel.setText("Node: N/A");
        this.pidLabel.setText("PID: N/A");
        this.statusLabel.setText("Status: N/A");
        this.outputText.setText("N/A");
        if (process != null) {
            this.rankLabel.setText("Rank: " + process.getProcessNumber());
            IPJob job = process.getJob();
            String jobNumber = job == null ? "none" : job.getJobNumber();
            this.jobLabel.setText("Job: " + jobNumber);
            this.pidLabel.setText("PID: " + process.getPid());
            this.statusLabel.setText("Status: " + process.getStatus());
            IPNode node = process.getNode();
            if (node != null) {
                this.totalLabel.setText("Total: " + node.getNumProcesses());
                this.nodeLabel.setText("Node: " + node.getNodeNumber());
            }
            this.outputText.setText(process.getContents());
        }
    }

    public void processEvent(final IProcessEvent event) {
        if (event.getProcess() != null && event.getProcess().equals(this.getProcess())) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    switch (event.getType()) {
                        case 0: {
                            ParallelProcessView.this.statusLabel.setText("Status: " + event.getInput());
                            break;
                        }
                        case 3: {
                            ParallelProcessView.this.outputText.append(event.getInput());
                        }
                    }
                }
            });
        }
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
        label.setFont(comp.getFont());
    }

    protected void updateStatusField(String category) {
        if (category == null) {
            return;
        }
        IStatusField field = this.getStatusField(category);
        if (field != null) {
            String text = null;
            if ("InputPosition".equals(category)) {
                text = this.pidLabel.getText();
            } else if ("ElementState".equals(category)) {
                text = this.rankLabel.getText();
            } else if ("InputMode".equals(category)) {
                text = this.getProcess().getStatus();
            }
            field.setText(text == null ? this.fErrorLabel : text);
        }
    }

    public void modelEvent(IModelEvent event) {
        IModelRuntimeNotifierEvent runEvent;
        if (event instanceof IModelRuntimeNotifierEvent && (runEvent = (IModelRuntimeNotifierEvent)event).getType() == 3) {
            this.close();
        }
    }
}

