/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.views;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.core.IModelPresentation;
import org.eclipse.ptp.core.IPElement;
import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerChangedListener;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ptp.rmsystem.IResourceManagerListener;
import org.eclipse.ptp.rmsystem.IResourceManagerMenuContribution;
import org.eclipse.ptp.rmsystem.ResourceManagerStatus;
import org.eclipse.ptp.ui.UIMessage;
import org.eclipse.ptp.ui.actions.AddResourceManagerAction;
import org.eclipse.ptp.ui.actions.RemoveResourceManagersAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class ResourceManagerView
extends ViewPart
implements IResourceManagerChangedListener,
IResourceManagerListener {
    private TreeViewer viewer;
    private RemoveResourceManagersAction removeResourceManagerAction;
    private AddResourceManagerAction addResourceManagerAction;
    private RMWrapper currentRMWrapper;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 2);
        this.viewer.setContentProvider((IContentProvider)new TheContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TheLabelProvider());
        this.viewer.setInput((Object)PTPCorePlugin.getDefault().getResourceManagers());
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        PTPCorePlugin.getDefault().addResourceManagerChangedListener((IResourceManagerChangedListener)this);
    }

    public void dispose() {
        PTPCorePlugin.getDefault().removeResourceManagerChangedListener((IResourceManagerChangedListener)this);
        super.dispose();
    }

    public void handleContentsChanged(IResourceManager resourceManager) {
        this.viewer.refresh((Object)resourceManager);
        this.refreshViewer(resourceManager);
    }

    public void handleCurrentResourceManagerChanged(IResourceManager oldRmManager, IResourceManager newRmManager) {
        this.viewer.refresh();
    }

    public void handleResourceManagersAddedRemoved() {
        this.viewer.setInput((Object)PTPCorePlugin.getDefault().getResourceManagers());
    }

    public void handleStarted(IResourceManager resourceManager) {
        this.refreshViewer(resourceManager);
    }

    public void handleStatusChanged(ResourceManagerStatus oldStatus, IResourceManager resourceManager) {
        if (oldStatus.equals(ResourceManagerStatus.STARTED) || resourceManager.getStatus().equals(ResourceManagerStatus.STARTED)) {
            this.refreshViewer(resourceManager);
        } else {
            this.updateViewer(resourceManager);
        }
    }

    public void handleStopped(IResourceManager resourceManager) {
        this.refreshViewer(resourceManager);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createContextMenu() {
        Shell shell = this.getSite().getShell();
        this.addResourceManagerAction = new AddResourceManagerAction(shell);
        this.removeResourceManagerAction = new RemoveResourceManagersAction(shell);
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ResourceManagerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        manager.add((IAction)this.addResourceManagerAction);
        Object[] selectedObjects = selection.toArray();
        boolean inContext = selection.size() > 0;
        int i = 0;
        while (i < selectedObjects.length) {
            if (!(selectedObjects[i] instanceof IResourceManagerMenuContribution)) {
                inContext = false;
            }
            ++i;
        }
        manager.add((IAction)this.removeResourceManagerAction);
        this.removeResourceManagerAction.setEnabled(inContext);
        if (inContext) {
            IResourceManager[] rmManagers = new IResourceManager[selection.size()];
            int i2 = 0;
            while (i2 < rmManagers.length) {
                IResourceManagerMenuContribution menuContrib = (IResourceManagerMenuContribution)selectedObjects[i2];
                rmManagers[i2] = (IResourceManager)menuContrib.getAdapter(IResourceManager.class);
                ++i2;
            }
            this.removeResourceManagerAction.setResourceManager(rmManagers);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additions-end"));
    }

    private void refreshViewer(IResourceManager resourceManager) {
        this.viewer.refresh((Object)resourceManager);
        if (this.currentRMWrapper.rm == resourceManager) {
            this.viewer.refresh((Object)this.currentRMWrapper);
        }
    }

    private void updateViewer(IResourceManager resourceManager) {
        this.viewer.update((Object)resourceManager, null);
        if (this.currentRMWrapper.rm == resourceManager) {
            this.viewer.update((Object)this.currentRMWrapper, null);
        }
    }

    public class ChildContainer {
        private final Object parent;
        private final String name;
        private final Object[] children;

        public ChildContainer(Object parent, String name, Object[] children) {
            this.parent = parent;
            this.name = name;
            this.children = children;
        }

        public Object[] getChildren() {
            return this.children;
        }

        public String getName() {
            return this.name;
        }

        public Object getParent() {
            return this.parent;
        }

        public boolean hasChildren() {
            return this.children != null && this.children.length > 0;
        }
    }

    public class RMWrapper
    implements IResourceManagerMenuContribution {
        private final IResourceManager rm;

        public RMWrapper(IResourceManager rm) {
            this.rm = rm;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isInstance(this.rm)) {
                return this.rm;
            }
            return this.rm.getAdapter(adapter);
        }
    }

    public class TheContentProvider
    implements ITreeContentProvider {
        private final HashMap parents = new HashMap();

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ChildContainer) {
                ChildContainer childContainer = (ChildContainer)parentElement;
                return childContainer.getChildren();
            }
            IResourceManager rm = null;
            if (parentElement instanceof IAdaptable) {
                rm = (IResourceManager)((IAdaptable)parentElement).getAdapter(IResourceManager.class);
            }
            if (rm != null) {
                if (!rm.getStatus().equals(ResourceManagerStatus.STARTED)) {
                    return new Object[0];
                }
                IModelPresentation modelPresentation = rm.getModelPresentation();
                Object[] machines = modelPresentation != null ? modelPresentation.getUniverse().getMachines() : new IPMachine[]{};
                return new Object[]{this.makeChildContainer(parentElement, UIMessage.getResourceString("ResourceManagerView.Machines"), machines), this.makeChildContainer(parentElement, UIMessage.getResourceString("ResourceManagerView.Queues"), new Object[0])};
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            PTPCorePlugin ptpCorePlugin = PTPCorePlugin.getDefault();
            IResourceManager currentResourceManager = ptpCorePlugin.getCurrentResourceManager();
            ResourceManagerView.this.currentRMWrapper = new RMWrapper(currentResourceManager);
            ChildContainer current = this.makeChildContainer(null, UIMessage.getResourceString("ResourceManagerView.CurrentResourceManager"), new RMWrapper[]{ResourceManagerView.this.currentRMWrapper});
            Object[] resourceManagers = ptpCorePlugin.getResourceManagers();
            ChildContainer root = this.makeChildContainer(null, UIMessage.getResourceString("ResourceManagerView.ResourceManagers"), resourceManagers);
            return new Object[]{current, root};
        }

        public Object getParent(Object element) {
            if (element instanceof ChildContainer) {
                ChildContainer childContainer = (ChildContainer)element;
                return childContainer.getParent();
            }
            return this.parents.get(element);
        }

        public boolean hasChildren(Object element) {
            IResourceManager rm;
            if (element instanceof ChildContainer) {
                return ((ChildContainer)element).hasChildren();
            }
            if (element instanceof IAdaptable && (rm = (IResourceManager)((IAdaptable)element).getAdapter(IResourceManager.class)) != null) {
                return rm.getStatus().equals(ResourceManagerStatus.STARTED);
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            System.out.println("inputChanged: viewer = " + viewer);
            this.parents.clear();
            HashSet oldRMs = new HashSet();
            HashSet newRMs = new HashSet();
            if (oldInput != null) {
                IResourceManager[] oldManagers = (IResourceManager[])oldInput;
                oldRMs.addAll(Arrays.asList(oldManagers));
            }
            if (newInput != null) {
                IResourceManager[] newManagers = (IResourceManager[])newInput;
                newRMs.addAll(Arrays.asList(newManagers));
            }
            HashSet unaffectedRMs = new HashSet(oldRMs);
            unaffectedRMs.retainAll(newRMs);
            newRMs.removeAll(unaffectedRMs);
            oldRMs.removeAll(unaffectedRMs);
            for (IResourceManager rm : oldRMs) {
                rm.removeResourceManagerListener((IResourceManagerListener)ResourceManagerView.this);
            }
            for (IResourceManager rm : newRMs) {
                rm.addResourceManagerListener((IResourceManagerListener)ResourceManagerView.this);
            }
        }

        private ChildContainer makeChildContainer(Object parent, String name, Object[] children) {
            ChildContainer container = new ChildContainer(parent, name, children);
            int i = 0;
            while (i < children.length) {
                this.parents.put(children[i], container);
                ++i;
            }
            return container;
        }
    }

    public class TheLabelProvider
    extends LabelProvider {
        public void dispose() {
            super.dispose();
        }

        public Image getImage(Object element) {
            if (element == ResourceManagerView.this.currentRMWrapper) {
                element = ResourceManagerView.this.currentRMWrapper.rm;
            }
            if (element instanceof IResourceManager) {
                ResourceManagerStatus status = ((IResourceManager)element).getStatus();
                if (status.equals(ResourceManagerStatus.STARTED)) {
                    return ParallelImages.rmImages[1];
                }
                if (status.equals(ResourceManagerStatus.STOPPED) || status.equals(ResourceManagerStatus.INIT)) {
                    return ParallelImages.rmImages[0];
                }
                if (status.equals(ResourceManagerStatus.ERROR)) {
                    return ParallelImages.rmImages[3];
                }
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element == ResourceManagerView.this.currentRMWrapper) {
                element = ResourceManagerView.this.currentRMWrapper.rm;
            }
            if (element instanceof IResourceManager) {
                IResourceManagerConfiguration configuration = ((IResourceManager)element).getConfiguration();
                IResourceManagerFactory factory = PTPCorePlugin.getDefault().getResourceManagerFactory(configuration.getResourceManagerId());
                return String.valueOf(configuration.getName()) + " (" + factory.getName() + ")";
            }
            if (element instanceof ChildContainer) {
                return ((ChildContainer)element).getName();
            }
            if (element instanceof IPElement) {
                IPElement ipelement = (IPElement)element;
                return ipelement.getElementName();
            }
            return super.getText(element);
        }

        public boolean isLabelProperty(Object element, String property) {
            return super.isLabelProperty(element, property);
        }
    }
}

