/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.UIMessage;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizardPage;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizardPageFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class RMConfigurationWizard
extends Wizard {
    private RMConfigurationWizardPage[][] cachedPages;
    private final ArrayList wizardPages = new ArrayList();
    private IResourceManagerConfiguration[] configs = null;
    private final SelectFactoryPage selectFactoryPage;
    private final IResourceManagerFactory[] factories;
    private final boolean hasFactories;
    private IResourceManagerFactory resourceManagerFactory;
    private boolean useDefaultNameAndDesc = false;
    private final NameAndDescPage nameAndDescPage;
    private int selectedFactory = -1;

    public RMConfigurationWizard(IResourceManagerFactory[] resourceManagerFactories) {
        this.setForcePreviousAndNextButtons(true);
        this.factories = resourceManagerFactories;
        this.hasFactories = this.factories.length > 0;
        this.cachedPages = new RMConfigurationWizardPage[this.factories.length][];
        this.configs = new IResourceManagerConfiguration[this.factories.length];
        this.selectFactoryPage = new SelectFactoryPage(UIMessage.getResourceString("ConfigurationWizard.FirstWizardPageName"));
        this.nameAndDescPage = new NameAndDescPage(UIMessage.getResourceString("ConfigurationWizard.LastWizardPageName"));
    }

    public void addPages() {
        this.addPage((IWizardPage)this.selectFactoryPage);
        this.addPage((IWizardPage)this.nameAndDescPage);
        super.addPages();
    }

    public boolean canFinish() {
        if (!this.hasFactories) {
            return false;
        }
        int numPages = this.getNumPages();
        int i = 0;
        while (i < numPages) {
            WizardPage page = (WizardPage)this.wizardPages.get(i);
            if (!page.isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IResourceManagerConfiguration getConfiguration() {
        return this.configs[this.selectedFactory];
    }

    public String getDescription() {
        return this.nameAndDescPage.descText.getText();
    }

    public String getName() {
        return this.nameAndDescPage.nameText.getText();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        int numPages = this.getNumPages();
        int index = this.wizardPages.indexOf(page);
        if (index == numPages - 1 || index == -1) {
            return null;
        }
        return (IWizardPage)this.wizardPages.get(index + 1);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        int index = this.wizardPages.indexOf(page);
        if (index == 0 || index == -1) {
            return null;
        }
        return (IWizardPage)this.wizardPages.get(index - 1);
    }

    public boolean performFinish() {
        System.out.println("In performFinish()");
        IResourceManagerConfiguration config = this.configs[this.selectedFactory];
        if (this.useDefaultNameAndDesc) {
            config.setDefaultNameAndDesc();
        }
        IResourceManager rm = this.resourceManagerFactory.create(config);
        PTPCorePlugin.getDefault().addResourceManager(rm);
        Arrays.fill(this.configs, null);
        return true;
    }

    private void factorySelected(int selectedFactory) {
        this.selectedFactory = selectedFactory;
        this.resourceManagerFactory = this.factories[selectedFactory];
        if (this.configs[selectedFactory] == null) {
            this.configs[selectedFactory] = this.resourceManagerFactory.createConfiguration();
        }
        this.nameAndDescPage.setNameAndDescription(this.configs[selectedFactory]);
        this.setWizardPages(selectedFactory);
    }

    private int getNumPages() {
        return this.needsLastPage() ? this.wizardPages.size() : this.wizardPages.size() - 1;
    }

    private boolean needsLastPage() {
        return !this.useDefaultNameAndDesc;
    }

    private void setWizardPages(int index) {
        if (this.cachedPages[index] == null) {
            PTPUIPlugin uiPlugin = PTPUIPlugin.getDefault();
            RMConfigurationWizardPageFactory factory = uiPlugin.getRMConfigurationWizardPageFactory(this.resourceManagerFactory);
            if (factory != null) {
                this.cachedPages[index] = factory.getPages(this);
            }
            if (this.cachedPages[index] == null) {
                this.cachedPages[index] = new RMConfigurationWizardPage[0];
            }
            int i = 0;
            while (i < this.cachedPages[index].length) {
                this.addPage((IWizardPage)this.cachedPages[index][i]);
                ++i;
            }
        }
        this.wizardPages.clear();
        this.wizardPages.add(this.selectFactoryPage);
        this.wizardPages.addAll((Collection)Arrays.asList(this.cachedPages[index]));
        this.wizardPages.add(this.nameAndDescPage);
    }

    public class NameAndDescPage
    extends WizardPage {
        private Text descText;
        private Text nameText;

        public NameAndDescPage(String pageName) {
            super(pageName);
            this.setTitle(pageName);
            this.setDescription(UIMessage.getResourceString("ConfigurationWizard.WizardDesc"));
        }

        public void createControl(Composite parent) {
            Group mainGroup = new Group(parent, 0);
            mainGroup.setLayout((Layout)new GridLayout(1, false));
            mainGroup.setText(UIMessage.getResourceString("ConfigurationWizard.HeadLabel"));
            this.createNameDescControl(mainGroup);
            boolean textAndDescriptionEnabled = RMConfigurationWizard.this.hasFactories;
            this.nameText.setEnabled(textAndDescriptionEnabled);
            this.descText.setEnabled(textAndDescriptionEnabled);
            this.setControl((Control)mainGroup);
        }

        private void createNameDescControl(Group mainGroup) {
            Group nameGroup = new Group((Composite)mainGroup, 0);
            nameGroup.setLayout((Layout)new GridLayout(1, false));
            nameGroup.setLayoutData((Object)new GridData(768));
            nameGroup.setText(UIMessage.getResourceString("ConfigurationWizard.NameDescriptiion"));
            Label nameLabel = new Label((Composite)nameGroup, 0);
            nameLabel.setText(UIMessage.getResourceString("ConfigurationWizard.NameLabel"));
            this.nameText = new Text((Composite)nameGroup, 2048);
            this.nameText.setLayoutData((Object)new GridData(768));
            this.nameText.setText("");
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RMConfigurationWizard.this.configs[RMConfigurationWizard.this.selectedFactory].setName(NameAndDescPage.this.nameText.getText());
                }
            });
            Label descLabel = new Label((Composite)nameGroup, 0);
            descLabel.setText(UIMessage.getResourceString("ConfigurationWizard.DescriptionLabel"));
            this.descText = new Text((Composite)nameGroup, 2048);
            this.descText.setLayoutData((Object)new GridData(768));
            this.descText.setText("");
            this.descText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RMConfigurationWizard.this.configs[RMConfigurationWizard.this.selectedFactory].setDescription(NameAndDescPage.this.descText.getText());
                }
            });
        }

        private void setEnabled(boolean enabled) {
            this.nameText.setEnabled(enabled);
            this.descText.setEnabled(enabled);
        }

        private void setNameAndDescription(IResourceManagerConfiguration config) {
            this.nameText.setText(config.getName());
            this.descText.setText(config.getDescription());
        }
    }

    private class SelectFactoryPage
    extends WizardPage {
        private List factoryList;

        public SelectFactoryPage(String pageName) {
            super(pageName);
            this.setTitle(pageName);
            this.setDescription(UIMessage.getResourceString("ConfigurationWizard.WizardDesc"));
        }

        public void createControl(Composite parent) {
            Group mainGroup = new Group(parent, 0);
            mainGroup.setLayout((Layout)new GridLayout(1, false));
            mainGroup.setText(UIMessage.getResourceString("ConfigurationWizard.HeadLabel"));
            this.createRMFactoryChoiceControl((Composite)mainGroup);
            if (RMConfigurationWizard.this.hasFactories) {
                parent.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        SelectFactoryPage.this.factoryList.select(0);
                        SelectFactoryPage.this.handleFactorySeclection();
                    }
                });
            }
            this.setControl((Control)mainGroup);
        }

        private void createRMFactoryChoiceControl(Composite container) {
            String[] factoryNames = new String[RMConfigurationWizard.this.factories.length];
            int i = 0;
            while (i < RMConfigurationWizard.this.factories.length) {
                factoryNames[i] = RMConfigurationWizard.this.factories[i].getName();
                ++i;
            }
            Group factoryGroup = new Group(container, 0);
            factoryGroup.setLayout((Layout)new GridLayout(1, false));
            factoryGroup.setText(UIMessage.getResourceString("ConfigurationWizard.ChooseResourceManager"));
            factoryGroup.setLayoutData((Object)new GridData(768));
            Label factoryLabel = new Label((Composite)factoryGroup, 0);
            factoryLabel.setText(UIMessage.getResourceString("ConfigurationWizard.ResourceManagerTypesLabel"));
            this.factoryList = new List((Composite)factoryGroup, 2564);
            this.factoryList.setLayoutData((Object)new GridData(768));
            this.factoryList.setItems(factoryNames);
            this.factoryList.setEnabled(RMConfigurationWizard.this.hasFactories);
            this.factoryList.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    SelectFactoryPage.this.handleFactorySeclection();
                }
            });
            final Button useDefaultNameDescButton = new Button(container, 34);
            useDefaultNameDescButton.setText(UIMessage.getResourceString("ConfigurationWizard.UseDefaultButtonLabel"));
            useDefaultNameDescButton.setSelection(false);
            useDefaultNameDescButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    RMConfigurationWizard.this.useDefaultNameAndDesc = useDefaultNameDescButton.getSelection();
                    boolean enabled = RMConfigurationWizard.this.hasFactories && !RMConfigurationWizard.this.useDefaultNameAndDesc;
                    RMConfigurationWizard.this.nameAndDescPage.setEnabled(enabled);
                    SelectFactoryPage.this.getContainer().updateButtons();
                }
            });
        }

        private void handleFactorySeclection() {
            int index = this.factoryList.getSelectionIndex();
            RMConfigurationWizard.this.factorySelected(index);
            this.setPageComplete(true);
        }
    }
}

