/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIObject;
import org.eclipse.ptp.debug.core.cdi.model.IPCDISignal;
import org.eclipse.ptp.debug.external.core.cdi.Manager;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.event.SignalChangedEvent;
import org.eclipse.ptp.debug.external.core.cdi.model.Signal;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.commands.CLIHandleCommand;
import org.eclipse.ptp.debug.external.core.commands.CLIListSignalsCommand;

public class SignalManager
extends Manager {
    IPCDISignal[] EMPTY_SIGNALS = new IPCDISignal[0];
    Signal[] noSigs = new Signal[0];
    Map signalsMap = new Hashtable();

    public SignalManager(Session session) {
        super(session, false);
    }

    public void shutdown() {
        this.signalsMap.clear();
    }

    synchronized List getSignalsList(Target target) {
        List signalsList = (List)this.signalsMap.get(target);
        if (signalsList == null) {
            signalsList = Collections.synchronizedList(new ArrayList());
            this.signalsMap.put(target, signalsList);
        }
        return signalsList;
    }

    IPCDISignal[] createSignals(Target target) throws PCDIException {
        return this.createSignals(target, null);
    }

    IPCDISignal[] createSignals(Target target, String name) throws PCDIException {
        CLIListSignalsCommand command = new CLIListSignalsCommand(target.getTask(), name);
        target.getDebugger().postCommand((IDebugCommand)command);
        IPCDISignal[] signals = command.getInfoSignals();
        if (signals.length == 0) {
            throw new PCDIException("No signal found");
        }
        return signals;
    }

    private boolean hasSignalChanged(IPCDISignal sig, IPCDISignal signal) {
        return !sig.getName().equals(signal.getName()) || sig.isStopSet() != signal.isStop() || sig.isIgnore() != !signal.isPass();
    }

    protected IPCDISignal findSignal(Target target, String name) {
        IPCDISignal sig = null;
        List signalsList = (List)this.signalsMap.get(target);
        if (signalsList != null) {
            IPCDISignal[] sigs = signalsList.toArray(new IPCDISignal[0]);
            int i = 0;
            while (i < sigs.length) {
                if (sigs[i].getName().equals(name)) {
                    sig = sigs[i];
                    break;
                }
                ++i;
            }
        }
        return sig;
    }

    public IPCDISignal getSignal(Target target, String name) {
        IPCDISignal sig = this.findSignal(target, name);
        if (sig == null) {
            sig = new Signal(target, name, false, false, false, name);
        }
        return sig;
    }

    public void handle(Signal sig, boolean isIgnore, boolean isStop) throws PCDIException {
        StringBuffer buffer = new StringBuffer(sig.getName());
        buffer.append(" ");
        if (isIgnore) {
            buffer.append("ignore");
        } else {
            buffer.append("noignore");
        }
        buffer.append(" ");
        if (isStop) {
            buffer.append("stop");
        } else {
            buffer.append("nostop");
        }
        Target target = (Target)sig.getTarget();
        CLIHandleCommand command = new CLIHandleCommand(target.getTask(), buffer.toString());
        target.getDebugger().postCommand((IDebugCommand)command);
        if (command.isWaitForReturn()) {
            sig.setHandle(isIgnore, isStop);
            target.getDebugger().fireEvents(new IPCDIEvent[]{new SignalChangedEvent(target.getSession(), target.getTask(), sig, sig.getName())});
        }
    }

    public IPCDISignal[] getSignals(Target target) throws PCDIException {
        List signalsList = (List)this.signalsMap.get(target);
        if (signalsList == null) {
            this.update(target);
        }
        if ((signalsList = (List)this.signalsMap.get(target)) != null) {
            return signalsList.toArray(new IPCDISignal[0]);
        }
        return this.EMPTY_SIGNALS;
    }

    public void update(Target target) throws PCDIException {
        IPCDISignal[] new_sigs = this.createSignals(target);
        ArrayList<SignalChangedEvent> eventList = new ArrayList<SignalChangedEvent>(new_sigs.length);
        List signalsList = this.getSignalsList(target);
        int i = 0;
        while (i < new_sigs.length) {
            IPCDISignal sig = this.findSignal(target, new_sigs[i].getName());
            if (sig != null) {
                if (this.hasSignalChanged(sig, new_sigs[i])) {
                    ((Signal)sig).setSignal(new_sigs[i]);
                    eventList.add(new SignalChangedEvent(target.getSession(), target.getTask(), (IPCDIObject)new_sigs[i], new_sigs[i].getName()));
                }
            } else {
                signalsList.add(new Signal(target, new_sigs[i]));
            }
            ++i;
        }
        IPCDIEvent[] events = eventList.toArray(new IPCDIEvent[0]);
        target.getDebugger().fireEvents(events);
    }
}

