/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.breakpoints;

import org.eclipse.ptp.debug.core.cdi.IPCDICondition;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIBreakpoint;
import org.eclipse.ptp.debug.external.core.cdi.Condition;
import org.eclipse.ptp.debug.external.core.cdi.model.PObject;

public abstract class Breakpoint
extends PObject
implements IPCDIBreakpoint {
    IPCDICondition condition;
    int bpid = -1;
    int type;
    boolean enable;

    public Breakpoint(int kind, IPCDICondition cond) {
        super(null);
        this.type = kind;
        this.condition = cond;
        this.enable = true;
    }

    public IPCDICondition getCondition() throws PCDIException {
        if (this.condition == null) {
            this.condition = new Condition(0, new String(), null);
        }
        return this.condition;
    }

    public boolean isEnabled() throws PCDIException {
        return this.enable;
    }

    public int getType() {
        return this.type;
    }

    public boolean isHardware() {
        return this.type == 2;
    }

    public boolean isTemporary() {
        return this.type == 1;
    }

    public void setCondition(IPCDICondition newCondition) {
        this.condition = newCondition;
    }

    public void setEnabled(boolean on) {
        this.enable = on;
    }

    public int getBreakpointId() {
        return this.bpid;
    }

    public void setBreakpointId(int bpid) {
        this.bpid = bpid;
    }
}

