/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.model;

import java.util.ArrayList;
import java.util.List;

public class Memory {
    String addr;
    long[] data = new long[0];
    List badOffsets = new ArrayList();
    String ascii = "";

    public Memory(String addr, String ascii, String[] values) {
        this.addr = addr;
        this.ascii = ascii;
        this.parse(values);
    }

    private void parse(String[] values) {
        this.data = new long[values.length];
        int i = 0;
        while (i < values.length) {
            try {
                this.data[i] = Long.decode(values[i].trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.badOffsets.add(new Integer(i));
                this.data[i] = 0L;
            }
            ++i;
        }
    }

    public String getAddress() {
        return this.addr;
    }

    public long[] getData() {
        return this.data;
    }

    public int[] getBadOffsets() {
        int[] data = new int[this.badOffsets.size()];
        int i = 0;
        while (i < data.length) {
            Integer o = (Integer)this.badOffsets.get(i);
            data[i] = o;
            ++i;
        }
        return data;
    }

    public String getAscii() {
        return this.ascii;
    }

    public String toSting() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("addr=\"" + this.addr + "\"");
        buffer.append("data=[");
        int i = 0;
        while (i < this.data.length) {
            if (i != 0) {
                buffer.append(',');
            }
            buffer.append('\"').append(Long.toHexString(this.data[i])).append('\"');
            ++i;
        }
        buffer.append(']');
        if (this.ascii.length() > 0) {
            buffer.append(",ascii=\"" + this.ascii + "\"");
        }
        return buffer.toString();
    }
}

