/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocation;
import org.eclipse.ptp.debug.core.cdi.model.IPCDISignal;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThread;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThreadStorage;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThreadStorageDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.VariableManager;
import org.eclipse.ptp.debug.external.core.cdi.model.PObject;
import org.eclipse.ptp.debug.external.core.cdi.model.StackFrame;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.ThreadStorageDescriptor;
import org.eclipse.ptp.debug.external.core.commands.GetStackInfoDepthCommand;
import org.eclipse.ptp.debug.external.core.commands.ListStackFramesCommand;
import org.eclipse.ptp.debug.external.core.commands.SetCurrentStackFrameCommand;
import org.eclipse.ptp.debug.external.core.proxy.ProxyDebugStackframe;

public class Thread
extends PObject
implements IPCDIThread {
    static IPCDIStackFrame[] noStack = new IPCDIStackFrame[0];
    int id;
    String name;
    StackFrame currentFrame;
    List currentFrames;
    int stackdepth = 0;
    public static final int STACKFRAME_DEFAULT_DEPTH = 200;

    public Thread(Target target, int threadId) {
        this(target, threadId, null);
    }

    public Thread(Target target, int threadId, String threadName) {
        super(target);
        this.id = threadId;
        this.name = threadName;
    }

    public int getId() {
        return this.id;
    }

    public void clearState() {
        this.stackdepth = 0;
        this.currentFrame = null;
        this.currentFrames = null;
    }

    public String toString() {
        String str = Integer.toString(this.id);
        if (this.name != null) {
            str = String.valueOf(str) + " " + this.name;
        }
        return str;
    }

    public void updateState() {
        try {
            this.getCurrentStackFrame();
        }
        catch (PCDIException pCDIException) {}
    }

    public StackFrame getCurrentStackFrame() throws PCDIException {
        IPCDIStackFrame[] frames;
        if (this.currentFrame == null && (frames = this.getStackFrames(0, 0)).length > 0) {
            this.currentFrame = (StackFrame)frames[0];
        }
        return this.currentFrame;
    }

    public IPCDIStackFrame[] getStackFrames() throws PCDIException {
        int depth = this.getStackFrameCount();
        if (this.currentFrames == null || this.currentFrames.size() < depth) {
            this.currentFrames = new ArrayList();
            Target target = (Target)this.getTarget();
            IPCDIThread currentThread = target.getCurrentThread();
            target.setCurrentThread(this, false);
            ListStackFramesCommand command = new ListStackFramesCommand(target.getTask());
            try {
                target.getDebugger().postCommand((IDebugCommand)command);
                ProxyDebugStackframe[] frames = command.getStackFrames();
                int i = 0;
                while (i < frames.length) {
                    this.currentFrames.add(new StackFrame(this, depth - frames[i].getLevel(), frames[i].getLocator(), null));
                    ++i;
                }
            }
            finally {
                target.setCurrentThread(currentThread, false);
            }
            if (this.currentFrame == null) {
                int i = 0;
                while (i < this.currentFrames.size()) {
                    IPCDIStackFrame stack = (IPCDIStackFrame)this.currentFrames.get(i);
                    if (stack.getLevel() == depth) {
                        this.currentFrame = (StackFrame)stack;
                    }
                    ++i;
                }
            }
        }
        return this.currentFrames.toArray(noStack);
    }

    public int getStackFrameCount() throws PCDIException {
        if (this.stackdepth == 0) {
            Target target = (Target)this.getTarget();
            IPCDIThread currentThread = target.getCurrentThread();
            target.setCurrentThread(this, false);
            GetStackInfoDepthCommand command = new GetStackInfoDepthCommand(target.getTask());
            try {
                try {
                    target.getDebugger().postCommand((IDebugCommand)command);
                    this.stackdepth = command.getDepth();
                }
                catch (PCDIException pCDIException) {
                    command = new GetStackInfoDepthCommand(target.getTask());
                    target.getDebugger().postCommand((IDebugCommand)command);
                    this.stackdepth = command.getDepth();
                    if (this.stackdepth > 0) {
                        --this.stackdepth;
                    }
                }
            }
            finally {
                target.setCurrentThread(currentThread, false);
            }
        }
        return this.stackdepth;
    }

    public IPCDIStackFrame[] getStackFrames(int low, int high) throws PCDIException {
        if (this.currentFrames == null || this.currentFrames.size() < high) {
            this.currentFrames = new ArrayList();
            Target target = (Target)this.getTarget();
            IPCDIThread currentThread = target.getCurrentThread();
            target.setCurrentThread(this, false);
            try {
                int depth = this.getStackFrameCount();
                int upperBound = high < depth ? Math.min(depth, 200) : depth;
                ListStackFramesCommand command = new ListStackFramesCommand(target.getTask(), 0, upperBound);
                target.getDebugger().postCommand((IDebugCommand)command);
                ProxyDebugStackframe[] frames = command.getStackFrames();
                int i = 0;
                while (i < frames.length) {
                    this.currentFrames.add(new StackFrame(this, depth - frames[i].getLevel(), frames[i].getLocator(), null));
                    ++i;
                }
            }
            finally {
                target.setCurrentThread(currentThread, false);
            }
            if (this.currentFrame == null) {
                int i = 0;
                while (i < this.currentFrames.size()) {
                    StackFrame f = (StackFrame)this.currentFrames.get(i);
                    if (f.getLevel() == 0) {
                        this.currentFrame = f;
                    }
                    ++i;
                }
            }
        }
        List list = high - low + 1 <= this.currentFrames.size() ? this.currentFrames.subList(low, high + 1) : this.currentFrames;
        return list.toArray(noStack);
    }

    public void setCurrentStackFrame(StackFrame stackframe, boolean doUpdate) throws PCDIException {
        Thread aThread;
        int frameLevel = 0;
        if (stackframe != null) {
            frameLevel = stackframe.getLevel();
        }
        if (this.currentFrame != null && this.currentFrame.getLevel() == frameLevel && stackframe != null && (aThread = (Thread)stackframe.getThread()) != null && aThread.getId() == this.getId()) {
            return;
        }
        Target target = (Target)this.getTarget();
        int level = this.getStackFrameCount() - frameLevel;
        SetCurrentStackFrameCommand command = new SetCurrentStackFrameCommand(target.getTask(), level);
        target.getDebugger().postCommand((IDebugCommand)command);
        if (command.isWaitForReturn()) {
            VariableManager varMgr;
            this.currentFrame = stackframe;
            if (doUpdate && (varMgr = ((Session)target.getSession()).getVariableManager()).isAutoUpdate()) {
                varMgr.update(target);
            }
        }
    }

    public void stepInto() throws PCDIException {
        this.stepInto(1);
    }

    public void stepInto(int count) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().stepInto(count);
    }

    public void stepIntoInstruction() throws PCDIException {
        this.stepIntoInstruction(1);
    }

    public void stepIntoInstruction(int count) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().stepIntoInstruction(count);
    }

    public void stepOver() throws PCDIException {
        this.stepOver(1);
    }

    public void stepOver(int count) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().stepOver(count);
    }

    public void stepOverInstruction() throws PCDIException {
        this.stepOverInstruction(1);
    }

    public void stepOverInstruction(int count) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().stepOverInstruction(count);
    }

    public void stepReturn() throws PCDIException {
        this.getCurrentStackFrame().stepReturn();
    }

    public void runUntil(IPCDILocation location) throws PCDIException {
        this.stepUntil(location);
    }

    public void stepUntil(IPCDILocation location) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().stepUntil(location);
    }

    public boolean isSuspended() {
        return this.getTarget().isSuspended();
    }

    public void suspend() throws PCDIException {
        this.getTarget().suspend();
    }

    public void resume() throws PCDIException {
        this.resume(false);
    }

    public void resume(boolean passSignal) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().resume(passSignal);
    }

    public void resume(IPCDILocation location) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().resume(location);
    }

    public void resume(IPCDISignal signal) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().resume(signal);
    }

    public void jump(IPCDILocation location) throws PCDIException {
        this.resume(location);
    }

    public void signal() throws PCDIException {
        this.resume(false);
    }

    public void signal(IPCDISignal signal) throws PCDIException {
        this.resume(signal);
    }

    public boolean equals(IPCDIThread thread) {
        if (thread instanceof Thread) {
            Thread cthread = (Thread)thread;
            return this.id == cthread.getId();
        }
        return super.equals(thread);
    }

    public IPCDIThreadStorageDescriptor[] getThreadStorageDescriptors() throws PCDIException {
        Session session = (Session)this.getTarget().getSession();
        VariableManager varMgr = session.getVariableManager();
        return varMgr.getThreadStorageDescriptors(this);
    }

    public IPCDIThreadStorage createThreadStorage(IPCDIThreadStorageDescriptor varDesc) throws PCDIException {
        if (varDesc instanceof ThreadStorageDescriptor) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager varMgr = session.getVariableManager();
            return varMgr.createThreadStorage((ThreadStorageDescriptor)varDesc);
        }
        return null;
    }
}

